/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.spring;

import com.icegreen.greenmail.spring.GreenMailBean;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class GreenMailBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final String DEFAULT_HOSTNAME = "localhost";
    private static final Integer DEFAULT_PORT_OFFSET = 3000;

    protected Class<?> getBeanClass(Element element) {
        return GreenMailBean.class;
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        builder.addPropertyValue("hostname", this.extractHostname(element));
        builder.addPropertyValue("portOffset", this.extractPortOffset(element));
    }

    private Object extractPortOffset(Element pElement) {
        Element portOffsetElement = DomUtils.getChildElementByTagName((Element)pElement, (String)"portOffset");
        if (null != portOffsetElement) {
            return portOffsetElement.getTextContent();
        }
        return DEFAULT_PORT_OFFSET;
    }

    private Object extractHostname(Element pElement) {
        Element hostnameElement = DomUtils.getChildElementByTagName((Element)pElement, (String)"hostname");
        if (null != hostnameElement) {
            return hostnameElement.getTextContent();
        }
        return DEFAULT_HOSTNAME;
    }
}

