/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.standalone;

import com.icegreen.greenmail.configuration.GreenMailConfiguration;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.user.UserManager;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class GreenMailApiResource {
    private static final Logger LOG = LoggerFactory.getLogger(GreenMailApiResource.class);
    private final GreenMail greenMail;
    private final ServerSetup[] serverSetups;
    private final GreenMailConfiguration configuration;
    private static final String INDEX_CONTENT = GreenMailApiResource.loadResource("index.html");
    private static final String OPENAPI_CONTENT = GreenMailApiResource.loadResource("greenmail-openapi.yml");

    public GreenMailApiResource(GreenMail greenMail, ServerSetup[] serverSetups, GreenMailConfiguration configuration) {
        this.greenMail = greenMail;
        this.serverSetups = serverSetups;
        this.configuration = configuration;
    }

    private static String loadResource(String name) {
        String string;
        block8: {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
            try {
                string = new Scanner(is, StandardCharsets.UTF_8.name()).useDelimiter("\\A").next();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NullPointerException e) {
                    throw new IllegalArgumentException("Can not load resource " + name + " from classpath", e);
                }
            }
            is.close();
        }
        return string;
    }

    @GET
    @Produces(value={"text/html"})
    public String index() {
        return INDEX_CONTENT;
    }

    @Path(value="/greenmail-openapi.yml")
    @GET
    @Produces(value={"application/yaml"})
    public String openapi() {
        return OPENAPI_CONTENT;
    }

    @GET
    @Path(value="/api/configuration")
    @Produces(value={"application/json"})
    public Response configuration() {
        Configuration config = new Configuration();
        config.serverSetups = this.serverSetups;
        config.authenticationDisabled = this.configuration.isAuthenticationDisabled();
        config.sieveIgnoreDetail = this.configuration.isSieveIgnoreDetailEnabled();
        config.preloadDirectory = this.configuration.getPreloadDir();
        return Response.status(Response.Status.OK).entity(config).build();
    }

    @GET
    @Path(value="/api/user")
    @Produces(value={"application/json"})
    public Collection<GreenMailUser> listUsers() {
        return this.greenMail.getUserManager().listUser();
    }

    @POST
    @Path(value="/api/user")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createUsers(User newUser) {
        try {
            GreenMailUser user = this.greenMail.getUserManager().createUser(newUser.email, newUser.login, newUser.password);
            LOG.debug("Created user {}", (Object)user);
            return Response.status(Response.Status.OK).entity(user).build();
        }
        catch (UserException e) {
            return Response.status(Response.Status.BAD_REQUEST).entity(new ErrorMessage("Can not create user : " + e.getMessage())).build();
        }
    }

    @DELETE
    @Path(value="/api/user/{emailOrLogin}")
    @Produces(value={"application/json"})
    public Response deleteUserById(@PathParam(value="emailOrLogin") String id) {
        UserManager userManager = this.greenMail.getUserManager();
        LOG.debug("Searching user using '{}'", (Object)id);
        GreenMailUser user = userManager.getUser(id);
        if (null == user) {
            user = userManager.getUserByEmail(id);
        }
        if (null == user) {
            return Response.status(Response.Status.BAD_REQUEST).entity(new ErrorMessage("User '" + id + "' not found")).build();
        }
        LOG.debug("Deleting user {}", (Object)user);
        userManager.deleteUser(user);
        return Response.status(Response.Status.OK).entity(new SuccessMessage("User '" + id + "' deleted")).build();
    }

    @POST
    @Path(value="/api/mail/purge")
    @Produces(value={"application/json"})
    public AbstractMessage purge() {
        try {
            this.greenMail.purgeEmailFromAllMailboxes();
            return new SuccessMessage("Purged mails");
        }
        catch (FolderException e) {
            return new ErrorMessage("Can not purge mails : " + e.getMessage());
        }
    }

    @POST
    @Path(value="/api/service/reset")
    @Produces(value={"application/json"})
    public AbstractMessage reset() {
        this.greenMail.reset();
        return new SuccessMessage("Performed reset");
    }

    @GET
    @Path(value="/api/service/readiness")
    @Produces(value={"application/json"})
    public Response ready() {
        if (this.greenMail.isRunning()) {
            return Response.status(Response.Status.OK).entity(new SuccessMessage("Service running")).build();
        }
        return Response.status(Response.Status.SERVICE_UNAVAILABLE).entity(new SuccessMessage("Service not running")).build();
    }

    public static class User {
        public String email;
        public String login;
        public String password;
    }

    static class Configuration {
        public ServerSetup[] serverSetups;
        public boolean authenticationDisabled;
        public boolean sieveIgnoreDetail;
        public String preloadDirectory;

        Configuration() {
        }
    }

    static class ErrorMessage
    extends AbstractMessage {
        protected ErrorMessage(String message) {
            super(message);
        }
    }

    static class SuccessMessage
    extends AbstractMessage {
        protected SuccessMessage(String message) {
            super(message);
        }
    }

    static abstract class AbstractMessage {
        private final String message;

        protected AbstractMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

