/*
 * Decompiled with CFR 0.152.
 */
package com.iluwatar.urm;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class DomainClassFinder {
    private static final Logger logger = Logger.getLogger(DomainClassFinder.class.getName());
    private static final String URM_PACKAGE = "com.iluwatar.urm";
    public static boolean ALLOW_FINDING_INTERNAL_CLASSES;
    public static ClassLoader[] classLoaders;

    public static List<Class<?>> findClasses(List<String> packages, List<String> ignores, ClassLoader classLoader) {
        return packages.stream().map(packageName -> DomainClassFinder.getClasses(classLoader, packageName)).flatMap(Collection::stream).filter(DomainClassFinder::isNotPackageInfo).filter(DomainClassFinder::isNotAnonymousClass).filter(clazz -> !ignores.contains(clazz.getName()) && !ignores.contains(clazz.getSimpleName())).sorted(Comparator.comparing(Class::getName)).collect(Collectors.toList());
    }

    private static boolean isNotPackageInfo(Class<?> clazz) {
        return !clazz.getSimpleName().equals("package-info");
    }

    private static boolean isNotAnonymousClass(Class<?> clazz) {
        return !clazz.getSimpleName().equals("");
    }

    private static Set<Class<?>> getClasses(ClassLoader classLoader, String packageName) {
        FilterBuilder filter = new FilterBuilder().includePackage(packageName);
        if (!DomainClassFinder.isAllowFindingInternalClasses()) {
            filter.excludePackage(URM_PACKAGE);
        }
        if (classLoader != null) {
            Reflections reflections = new Reflections(new ConfigurationBuilder().setScanners(new SubTypesScanner(false), new ResourcesScanner()).addClassLoaders(classLoader).forPackage(packageName, classLoader).filterInputsBy(filter));
            Sets.SetView<Class<?>> classes = Sets.union(reflections.getSubTypesOf(Object.class), reflections.getSubTypesOf(Enum.class));
            return classes;
        }
        Reflections reflections = new Reflections(new ConfigurationBuilder().setScanners(new SubTypesScanner(false), new ResourcesScanner()).forPackage(packageName, new ClassLoader[0]).filterInputsBy(filter));
        Sets.SetView<Class<?>> classes = Sets.union(reflections.getSubTypesOf(Object.class), reflections.getSubTypesOf(Enum.class));
        return classes;
    }

    public static boolean isAllowFindingInternalClasses() {
        return ALLOW_FINDING_INTERNAL_CLASSES |= Boolean.parseBoolean(System.getProperty("DomainClassFinder.allowFindingInternalClasses", "false"));
    }

    private DomainClassFinder() {
    }
}

