/*
 * Decompiled with CFR 0.152.
 */
package com.iluwatar.urm.domain;

import com.iluwatar.urm.domain.DomainClassType;
import com.iluwatar.urm.domain.DomainConstructor;
import com.iluwatar.urm.domain.DomainExecutable;
import com.iluwatar.urm.domain.DomainField;
import com.iluwatar.urm.domain.DomainMethod;
import com.iluwatar.urm.domain.TypeUtils;
import com.iluwatar.urm.domain.Visibility;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainClass {
    private static final Logger log = LoggerFactory.getLogger(DomainClass.class);
    protected static final List<String> IGNORED_METHODS = Arrays.asList("$jacocoInit");
    protected static final List<String> IGNORED_FIELDS = Arrays.asList("$jacocoData");
    private Class<?> clazz;
    private String description;
    private transient List<DomainField> fieldList;
    private transient List<DomainConstructor> constructorList;
    private transient List<DomainMethod> methodList;

    public DomainClass(Class<?> clazz, String description) {
        this.clazz = clazz;
        this.description = description;
    }

    public DomainClass(Class<?> clazz) {
        this(clazz, null);
    }

    private boolean isLambda(String s) {
        return s.contains("lambda$");
    }

    public String getPackageName() {
        return this.clazz.getPackage().getName();
    }

    public String getUmlName() {
        return TypeUtils.getSimpleName(this.clazz);
    }

    public String getClassName() {
        return this.clazz.getSimpleName();
    }

    public String getDescription() {
        return this.description;
    }

    public List<DomainField> getFields() {
        if (this.fieldList == null) {
            this.fieldList = Arrays.stream(this.clazz.getDeclaredFields()).filter(f -> !f.getDeclaringClass().isEnum() || !f.getName().equals("$VALUES")).filter(f -> !f.isSynthetic()).filter(f -> !IGNORED_FIELDS.contains(f.getName())).map(DomainField::new).sorted(Comparator.comparing(DomainField::getUmlName)).collect(Collectors.toList());
        }
        return this.fieldList;
    }

    public List<DomainConstructor> getConstructors() {
        if (this.constructorList == null) {
            this.constructorList = this.clazz.isEnum() ? Collections.emptyList() : Arrays.stream(this.clazz.getDeclaredConstructors()).filter(c -> !c.isSynthetic()).map(DomainConstructor::new).sorted(Comparator.comparing(DomainExecutable::getUmlName)).collect(Collectors.toList());
        }
        return this.constructorList;
    }

    public List<DomainMethod> getMethods() {
        if (this.methodList == null) {
            this.methodList = Arrays.stream(this.clazz.getDeclaredMethods()).filter(m -> !m.isSynthetic()).map(DomainMethod::new).filter(m -> !IGNORED_METHODS.contains(m.getName()) && !this.isLambda(m.getName())).sorted(Comparator.comparing(DomainExecutable::getUmlName)).collect(Collectors.toList());
        }
        return this.methodList;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, obj, new String[0]);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public Visibility getVisibility() {
        return TypeUtils.getVisibility(this.clazz.getModifiers());
    }

    public DomainClassType getClassType() {
        if (this.clazz.isInterface()) {
            return DomainClassType.INTERFACE;
        }
        if (this.clazz.isEnum()) {
            return DomainClassType.ENUM;
        }
        if (this.clazz.isAnnotation()) {
            return DomainClassType.ANNOTATION;
        }
        return DomainClassType.CLASS;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.clazz.getModifiers());
    }
}

