/*
 * Decompiled with CFR 0.152.
 */
package com.iluwatar.urm.domain;

import com.iluwatar.urm.domain.Visibility;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.stream.Collectors;

class TypeUtils {
    private static final String JAVA_IDENTIFIER_REGEX = "([a-zA-Z_$][a-zA-Z\\d_$]*)";

    TypeUtils() {
    }

    static Visibility getVisibility(int mod) {
        if (Modifier.isPublic(mod)) {
            return Visibility.PUBLIC;
        }
        if (Modifier.isProtected(mod)) {
            return Visibility.PROTECTED;
        }
        if (Modifier.isPrivate(mod)) {
            return Visibility.PRIVATE;
        }
        return Visibility.DEFAULT;
    }

    static String getSimpleName(Type type) {
        if (type instanceof ParameterizedType) {
            return TypeUtils.getSimpleTypeName((ParameterizedType)type);
        }
        if (type instanceof Class) {
            return TypeUtils.getSimpleTypeName((Class)type);
        }
        if (type instanceof TypeVariable) {
            return TypeUtils.getSimpleTypeName((TypeVariable)type);
        }
        return TypeUtils.cutPackages(type.getTypeName());
    }

    private static String getSimpleTypeName(TypeVariable type) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getTypeName());
        if (type.getBounds() == null || type.getBounds().length <= 0) {
            return sb.toString();
        }
        String boundsString = Arrays.stream(type.getBounds()).filter(t -> !t.getTypeName().equals("java.lang.Object")).map(t -> TypeUtils.getSimpleTypeNameWithoutTypeVariable(t, type)).collect(Collectors.joining(" & "));
        if (boundsString != null && boundsString.trim().length() > 0) {
            sb.append(" extends ");
            sb.append(boundsString);
        }
        return sb.toString();
    }

    static String getSimpleTypeName(ParameterizedType type) {
        StringBuilder sb = new StringBuilder();
        if (type.getOwnerType() != null) {
            if (type.getOwnerType() instanceof Class) {
                sb.append(((Class)type.getOwnerType()).getSimpleName());
            } else {
                sb.append(TypeUtils.cutPackages(type.getOwnerType().getTypeName()));
            }
            sb.append(".");
            sb.append(((Class)type.getRawType()).getSimpleName());
        } else {
            sb.append(((Class)type.getRawType()).getSimpleName());
        }
        Type[] actualTypeArguments = type.getActualTypeArguments();
        if (actualTypeArguments != null && actualTypeArguments.length > 0) {
            sb.append(TypeUtils.getTypeParameters(type, actualTypeArguments));
        }
        return sb.toString();
    }

    static String getSimpleTypeName(Class type) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getSimpleName());
        Type[] typeParameters = type.getTypeParameters();
        if (typeParameters != null && typeParameters.length > 0) {
            sb.append(TypeUtils.getTypeParameters(type, typeParameters));
        }
        return sb.toString();
    }

    private static String getTypeParameters(Type declaringType, Type[] typeParameters) {
        return Arrays.stream(typeParameters).filter(t -> !t.getTypeName().equals(declaringType.getTypeName())).map(TypeUtils::getSimpleName).collect(Collectors.joining(", ", "<", ">"));
    }

    private static String getSimpleTypeNameWithoutTypeVariable(Type t, TypeVariable type) {
        if (t instanceof TypeVariable) {
            return t.getTypeName();
        }
        if (t instanceof ParameterizedType) {
            if (((ParameterizedType)t).getRawType().equals(type.getGenericDeclaration())) {
                return ((Class)((ParameterizedType)t).getRawType()).getSimpleName();
            }
            return TypeUtils.cutPackages(t.getTypeName());
        }
        if (t instanceof Class) {
            return ((Class)t).getSimpleName();
        }
        return TypeUtils.getSimpleName(t);
    }

    static String cutPackages(String parameter) {
        return parameter.replaceAll("([a-zA-Z_$][a-zA-Z\\d_$]*)\\.", "");
    }
}

