/*
 * Decompiled with CFR 0.152.
 */
package com.iluwatar.urm.presenters;

import com.iluwatar.urm.domain.DomainClass;
import com.iluwatar.urm.domain.DomainClassType;
import com.iluwatar.urm.domain.Edge;
import com.iluwatar.urm.domain.EdgeType;
import com.iluwatar.urm.presenters.Presenter;
import com.iluwatar.urm.presenters.Representation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MermaidPresenter
implements Presenter {
    public static final String FILE_PREAMBLE = "classDiagram";

    private String describePackages(List<DomainClass> domainClasss) {
        return domainClasss.stream().collect(Collectors.groupingBy(DomainClass::getPackageName)).entrySet().stream().map(this::describePackage).collect(Collectors.joining());
    }

    private String describePackage(Map.Entry<String, List<DomainClass>> entry) {
        return this.listDomainClasses(entry.getValue());
    }

    private String listDomainClasses(List<DomainClass> domainClasses) {
        return domainClasses.stream().map(this::describeDomainClass).distinct().collect(Collectors.joining());
    }

    private String describeDomainClass(DomainClass domainClass) {
        return String.format("  %s {\n%s%s%s%s\n  }\n", this.describeDomainClassType(domainClass), this.describeDomainClassTypeAnnotation(domainClass), this.describeDomainClassFields(domainClass), this.describeDomainClassConstructors(domainClass), this.describeDomainClassMethods(domainClass));
    }

    private String describeDomainClassType(DomainClass domainClass) {
        String className = domainClass.getClassName();
        return "class " + className;
    }

    private String describeDomainClassTypeAnnotation(DomainClass domainClass) {
        switch (domainClass.getClassType()) {
            case CLASS: {
                return domainClass.isAbstract() ? "<<abstract>>" : "";
            }
            case INTERFACE: {
                return "<<interface>>";
            }
            case ENUM: {
                return "<<enumeration>>";
            }
            case ANNOTATION: {
                return "<<annotation>>";
            }
        }
        return "";
    }

    private String describeDomainClassFields(DomainClass domainClass) {
        String description = domainClass.getFields().stream().map(f -> f.getVisibility() + " " + f.getUmlName() + (f.isStatic() ? "$  " : "") + (f.isAbstract() ? "* " : "")).collect(Collectors.joining("\n    "));
        return !description.equals("") ? "\n    " + description : "";
    }

    private String describeDomainClassConstructors(DomainClass domainClass) {
        String description = domainClass.getConstructors().stream().map(c -> c.getVisibility() + " " + c.getUmlName()).collect(Collectors.joining("\n    "));
        return !description.equals("") ? "\n    " + description : "";
    }

    private String describeDomainClassMethods(DomainClass domainClass) {
        String description = domainClass.getMethods().stream().map(m -> m.getVisibility() + " " + m.getUmlName() + (m.isStatic() ? "$ " : "") + (m.isAbstract() ? "* " : "")).collect(Collectors.joining("\n    "));
        return !description.equals("") ? "\n    " + description : "";
    }

    @Override
    public Representation describe(List<DomainClass> domainObjects, List<Edge> edges) {
        String content = "classDiagram\n" + this.describePackages(domainObjects) + this.describeCompositions(edges) + this.describeInheritance(edges);
        return new Representation(content, "mmd");
    }

    private String describeCompositions(List<Edge> edges) {
        return edges.stream().filter(e -> e.type != EdgeType.EXTENDS).map(this::describeComposition).collect(Collectors.joining());
    }

    private String describeComposition(Edge compositionEdge) {
        return String.format("%s\n", this.describeEdge(compositionEdge));
    }

    private String describeEdge(Edge edge) {
        String sourceName = edge.source.getClassName();
        Object targetName = edge.target.getClassName();
        String arrow = "--";
        String arrowDescription = null;
        switch (edge.type) {
            case STATIC_INNER_CLASS: {
                arrow = "<..";
                break;
            }
            case INNER_CLASS: {
                arrow = "<--";
                break;
            }
            default: {
                arrow = "-->";
            }
        }
        if (edge.source.getDescription() == null) {
            arrow = MermaidPresenter.flip(arrow);
        } else {
            targetName = " \"-" + edge.source.getDescription() + "\" " + (String)targetName;
        }
        return String.format("%s %s %s", sourceName, arrow, targetName) + (String)(arrowDescription != null ? " : " + arrowDescription : "");
    }

    private String describeInheritance(List<Edge> edges) {
        return edges.stream().filter(e -> e.type == EdgeType.EXTENDS).map(this::describeInheritance).collect(Collectors.joining());
    }

    private String describeInheritance(Edge hierarchyEdge) {
        String arrow = "--|>";
        if (hierarchyEdge.target.getClassType() == DomainClassType.INTERFACE && hierarchyEdge.source.getClassType() != DomainClassType.INTERFACE) {
            arrow = "..|>";
        }
        return String.format("%s %s %s\n", hierarchyEdge.source.getClassName(), arrow, hierarchyEdge.target.getClassName());
    }

    private static String flip(String s) {
        String reversedString = new StringBuilder(s).reverse().toString();
        return reversedString.replaceAll("<", ">").replaceAll(">", "<");
    }

    @Override
    public String getFileEnding() {
        return "mmd";
    }
}

