/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptContext;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.cucumber.FeatureWrapper;
import java.util.Properties;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class ScriptBridge {
    private final ScriptContext context;

    public ScriptBridge(ScriptContext context) {
        this.context = context;
    }

    public ScriptContext getContext() {
        return this.context;
    }

    public void configure(String key, Object o) {
        this.context.configure(key, new ScriptValue(o));
    }

    public Object read(String fileName) {
        ScriptValue sv = FileUtils.readFile(fileName, this.context);
        return sv.getValue();
    }

    public void set(String name, Object o) {
        this.context.vars.put(name, o);
    }

    public void set(String name, String path, String expr) {
        Script.setValueByPath(name, path, expr, this.context);
    }

    public Object get(String exp) {
        ScriptValue sv;
        try {
            sv = Script.eval(exp, this.context);
        }
        catch (Exception e) {
            this.context.logger.warn("karate.get failed for expression: '{}': {}", (Object)exp, (Object)e.getMessage());
            return null;
        }
        if (sv != null) {
            return sv.getAfterConvertingFromJsonOrXmlIfNeeded();
        }
        return null;
    }

    public Object call(String fileName) {
        return this.call(fileName, null);
    }

    public Object call(String fileName, Object arg) {
        ScriptValue sv = FileUtils.readFile(fileName, this.context);
        switch (sv.getType()) {
            case FEATURE_WRAPPER: {
                FeatureWrapper feature = sv.getValue(FeatureWrapper.class);
                return Script.evalFeatureCall(feature, arg, this.context).getValue();
            }
            case JS_FUNCTION: {
                ScriptObjectMirror som = sv.getValue(ScriptObjectMirror.class);
                return Script.evalFunctionCall(som, arg, this.context).getValue();
            }
        }
        this.context.logger.warn("not a js function or feature file: {} - {}", (Object)fileName, (Object)sv);
        return null;
    }

    public String getEnv() {
        return this.context.env.env;
    }

    public Properties getProperties() {
        return System.getProperties();
    }

    public void log(Object ... objects) {
        this.context.logger.info("{}", (Object)new LogWrapper(objects));
    }

    static class LogWrapper {
        private final Object[] objects;

        LogWrapper(Object ... objects) {
            this.objects = objects;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Object o : this.objects) {
                sb.append(o).append(' ');
            }
            return sb.toString();
        }
    }
}

