/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptEnv;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.ScriptValueMap;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpConfig;
import com.intuit.karate.validator.Validator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class ScriptContext {
    public final Logger logger;
    private static final String KARATE_DOT_CONTEXT = "karate.context";
    public static final String KARATE_NAME = "karate";
    private static final String VAR_READ = "read";
    protected final ScriptValueMap vars;
    protected HttpClient client;
    protected final Map<String, Validator> validators;
    protected final ScriptEnv env;
    private ScriptValue headers = ScriptValue.NULL;
    private ScriptValue readFunction;
    private HttpConfig config;
    protected boolean logPrettyResponse = false;
    private boolean logPrettyRequest = false;

    public ScriptValueMap getVars() {
        return this.vars;
    }

    public ScriptValue getConfiguredHeaders() {
        return this.headers;
    }

    public boolean isLogPrettyRequest() {
        return this.logPrettyRequest;
    }

    public ScriptContext(ScriptEnv env, ScriptContext parent, Map<String, Object> arg) {
        this.env = env.refresh(null);
        this.logger = env.logger;
        if (parent != null) {
            this.vars = Script.clone(parent.vars);
            this.validators = parent.validators;
            this.readFunction = Script.eval(ScriptContext.getFileReaderFunction(), this);
            this.headers = parent.headers;
            this.config = parent.config;
            if (arg != null) {
                for (Map.Entry<String, Object> entry : arg.entrySet()) {
                    this.vars.put(entry.getKey(), entry.getValue());
                }
            }
            this.client = HttpClient.construct();
            this.client.configure(this.config, this);
        } else {
            this.vars = new ScriptValueMap();
            this.validators = Script.getDefaultValidators();
            this.readFunction = Script.eval(ScriptContext.getFileReaderFunction(), this);
            this.config = new HttpConfig();
            this.client = HttpClient.construct();
            this.client.configure(this.config, this);
            try {
                Script.callAndUpdateVarsIfMapReturned("read('classpath:karate-config.js')", null, this);
            }
            catch (Exception e) {
                this.logger.warn("start-up configuration failed, missing or bad 'karate-config.js'", (Throwable)e);
            }
        }
        this.logger.trace("karate context init - initial properties: {}", (Object)this.vars);
    }

    private static String getFileReaderFunction() {
        return "function(path) {\n  var FileUtils = Java.type('" + FileUtils.class.getCanonicalName() + "');\n  return FileUtils.readFile(path, " + KARATE_DOT_CONTEXT + ").value;\n}";
    }

    public void configure(String key, String exp) {
        this.configure(key, Script.eval(exp, this));
    }

    public void configure(String key, ScriptValue value) {
        if ((key = StringUtils.trimToEmpty((String)key)).equals("headers")) {
            this.headers = value;
            return;
        }
        if (key.equals("logPrettyResponse")) {
            this.logPrettyResponse = value.isBooleanTrue();
            return;
        }
        if (key.equals("logPrettyRequest")) {
            this.logPrettyRequest = value.isBooleanTrue();
            return;
        }
        if (key.equals("ssl")) {
            if (value.isString()) {
                this.config.setSslEnabled(true);
                this.config.setSslAlgorithm(value.getAsString());
            } else {
                this.config.setSslEnabled(value.isBooleanTrue());
            }
        } else if (key.equals("connectTimeout")) {
            this.config.setConnectTimeout(Integer.valueOf(value.getAsString()));
        } else if (key.equals("readTimeout")) {
            this.config.setReadTimeout(Integer.valueOf(value.getAsString()));
        } else if (key.equals("proxy")) {
            if (value.isString()) {
                this.config.setProxyUri(value.getAsString());
            } else {
                Map<String, Object> map = value.getAsMap();
                this.config.setProxyUri((String)map.get("uri"));
                this.config.setProxyUsername((String)map.get("username"));
                this.config.setProxyPassword((String)map.get("password"));
            }
        } else {
            throw new RuntimeException("unexpected 'configure' key: '" + key + "'");
        }
        this.client.configure(this.config, this);
    }

    public Map<String, Object> getVariableBindings() {
        Map<String, Object> map = Script.simplify(this.vars);
        if (this.readFunction != null) {
            map.put(VAR_READ, this.readFunction.getValue());
        }
        return map;
    }
}

