/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.FileUtils;
import com.intuit.karate.ScriptValue;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEnv {
    public final Logger logger;
    public final String env;
    public final File featureDir;
    public final String featureName;
    public final ClassLoader fileClassLoader;
    private final Map<String, ScriptValue> callCache;

    public ScriptEnv(String env, File featureDir, String featureName, ClassLoader fileClassLoader, Map<String, ScriptValue> callCache, Logger logger) {
        this.env = env;
        this.featureDir = featureDir;
        this.featureName = featureName;
        this.fileClassLoader = fileClassLoader;
        this.callCache = callCache;
        this.logger = logger;
    }

    public ScriptEnv(String env, File featureDir, String featureName, ClassLoader fileClassLoader) {
        this(env, featureDir, featureName, fileClassLoader, new HashMap<String, ScriptValue>(1), LoggerFactory.getLogger((String)"com.intuit.karate"));
    }

    public static ScriptEnv init(File featureDir, String featureName, ClassLoader classLoader) {
        return new ScriptEnv(null, featureDir, featureName, classLoader);
    }

    public static ScriptEnv init(String env, File featureDir) {
        return new ScriptEnv(env, featureDir, null, Thread.currentThread().getContextClassLoader());
    }

    public static ScriptEnv init(String env, File featureFile, String[] searchPaths, Logger logger) {
        return new ScriptEnv(env, featureFile.getParentFile(), featureFile.getName(), FileUtils.createClassLoader(searchPaths), new HashMap<String, ScriptValue>(1), logger);
    }

    public ScriptEnv refresh(String in) {
        String karateEnv = StringUtils.trimToNull((String)in);
        if (karateEnv == null && (karateEnv = StringUtils.trimToNull((String)this.env)) == null) {
            karateEnv = StringUtils.trimToNull((String)System.getProperty("karate.env"));
        }
        return new ScriptEnv(karateEnv, this.featureDir, this.featureName, this.fileClassLoader, this.callCache, this.logger);
    }

    public ScriptValue getFromCallCache(String key) {
        return this.callCache.get(key);
    }

    public void putInCallCache(String key, ScriptValue value) {
        this.callCache.put(key, value);
    }

    public String toString() {
        return this.featureName + ", env: " + this.env + ", dir: " + this.featureDir;
    }
}

