/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtils {
    private XmlUtils() {
    }

    public static String toString(Node node) {
        return XmlUtils.toString(node, false);
    }

    public static String toString(Node node, boolean pretty) {
        DOMSource domSource = new DOMSource(node);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            if (pretty) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Document toXmlDoc(String xml) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
            return builder.parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static XPathExpression compile(String path) {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        try {
            return xpath.compile(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static NodeList getNodeListByPath(Node node, String path) {
        XPathExpression expr = XmlUtils.compile(path);
        try {
            return (NodeList)expr.evaluate(node, XPathConstants.NODESET);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Node getNodeByPath(Node node, String path) {
        XPathExpression expr = XmlUtils.compile(path);
        try {
            return (Node)expr.evaluate(node, XPathConstants.NODE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getTextValueByPath(Node node, String path) {
        XPathExpression expr = XmlUtils.compile(path);
        try {
            return expr.evaluate(node);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setByPath(Node doc, String path, String value) {
        Node node = XmlUtils.getNodeByPath(doc, path);
        if (node.hasChildNodes() && node.getFirstChild().getNodeType() == 3) {
            node.getFirstChild().setTextContent(value);
        } else {
            node.setNodeValue(value);
        }
    }

    public static void setByPath(Document doc, String path, Node in) {
        Node node;
        if (in.getNodeType() == 9) {
            in = in.getFirstChild();
        }
        if ((node = XmlUtils.getNodeByPath(doc, path)) == null) {
            throw new RuntimeException("no results for xpath: " + path);
        }
        Node newNode = doc.importNode(in, true);
        if (node.hasChildNodes() && node.getFirstChild().getNodeType() == 3) {
            node.replaceChild(newNode, node.getFirstChild());
        } else {
            node.appendChild(newNode);
        }
    }

    public static DocumentContext toJsonDoc(Node node) {
        return JsonPath.parse((Object)XmlUtils.toObject(node));
    }

    private static Map<String, Object> getAttributes(Node node) {
        NamedNodeMap attribs = node.getAttributes();
        int attribCount = attribs.getLength();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(attribCount);
        for (int j = 0; j < attribCount; ++j) {
            Node attrib = attribs.item(j);
            map.put(attrib.getNodeName(), attrib.getNodeValue());
        }
        return map;
    }

    public static int getChildElementCount(Node node) {
        NodeList nodes = node.getChildNodes();
        int childCount = nodes.getLength();
        int childElementCount = 0;
        for (int i = 0; i < childCount; ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1) continue;
            ++childElementCount;
        }
        return childElementCount;
    }

    private static Object getElementAsObject(Node node) {
        int childElementCount = XmlUtils.getChildElementCount(node);
        if (childElementCount == 0) {
            return node.getTextContent();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(childElementCount);
        NodeList nodes = node.getChildNodes();
        int childCount = nodes.getLength();
        for (int i = 0; i < childCount; ++i) {
            Object childValue;
            Node child = nodes.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = child.getNodeName();
            Object object = childValue = child.hasChildNodes() ? XmlUtils.toObject(child) : null;
            if (map.containsKey(childName)) {
                ArrayList<Object> list;
                Object temp = map.get(childName);
                if (temp instanceof List) {
                    list = (ArrayList<Object>)temp;
                    list.add(childValue);
                    continue;
                }
                list = new ArrayList<Object>(childCount);
                map.put(childName, list);
                list.add(temp);
                list.add(childValue);
                continue;
            }
            map.put(childName, childValue);
        }
        return map;
    }

    public static Object toObject(Node node) {
        if (node.getNodeType() == 9) {
            node = node.getFirstChild();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(1);
            map.put(node.getNodeName(), XmlUtils.toObject(node));
            return map;
        }
        Object value = XmlUtils.getElementAsObject(node);
        if (node.hasAttributes()) {
            LinkedHashMap<String, Object> wrapper = new LinkedHashMap<String, Object>(2);
            wrapper.put("_", value);
            wrapper.put("@", XmlUtils.getAttributes(node));
            return wrapper;
        }
        return value;
    }

    public static Element fromObject(String name, Object o) {
        return XmlUtils.fromObject(XmlUtils.newDocument(), name, o);
    }

    public static Element fromObject(Document doc, String name, Object o) {
        if (o instanceof Map) {
            Map map = (Map)o;
            Object value = map.get("_");
            if (value != null) {
                Element element = XmlUtils.fromObject(doc, name, value);
                Map attribs = (Map)map.get("@");
                XmlUtils.addAttributes(element, attribs);
                return element;
            }
            Element element = XmlUtils.createElement(doc, name, null, null);
            for (Map.Entry entry : map.entrySet()) {
                String childName = (String)entry.getKey();
                Object childValue = entry.getValue();
                Element childNode = XmlUtils.fromObject(doc, childName, childValue);
                element.appendChild(childNode);
            }
            return element;
        }
        if (o instanceof List) {
            Element element = XmlUtils.createElement(doc, name, null, null);
            List list = (List)o;
            for (Object child : list) {
                Element childNode = XmlUtils.fromObject(doc, name, child);
                element.appendChild(childNode);
            }
            return element;
        }
        String value = o == null ? null : o.toString();
        return XmlUtils.createElement(doc, name, value, null);
    }

    public static Document newDocument() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return builder.newDocument();
    }

    public static void addAttributes(Element element, Map<String, Object> map) {
        if (map != null) {
            Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Object attrValue;
                Map.Entry<String, Object> entry;
                element.setAttribute(entry.getKey(), (attrValue = (entry = iterator.next()).getValue()) == null ? null : attrValue.toString());
            }
        }
    }

    public static Element createElement(Node node, String name, String value, Map<String, Object> attributes) {
        Document doc = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        Element element = doc.createElement(name);
        element.setTextContent(value);
        XmlUtils.addAttributes(element, attributes);
        return element;
    }

    public static Document toNewDocument(Node in) {
        Document doc = XmlUtils.newDocument();
        Node node = doc.importNode(in, true);
        doc.appendChild(node);
        return doc;
    }
}

