/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cucumber;

import com.intuit.karate.ScriptEnv;
import com.intuit.karate.cucumber.FeatureFile;
import com.intuit.karate.cucumber.FeatureWrapper;
import com.intuit.karate.cucumber.KarateBackend;
import com.intuit.karate.cucumber.KarateJunitFormatter;
import com.intuit.karate.cucumber.KarateStats;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeGlue;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.StopWatch;
import cucumber.runtime.UndefinedStepsTracker;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.xstream.LocalizedXStreams;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberRunner {
    private static final Logger logger = LoggerFactory.getLogger(CucumberRunner.class);
    private final ClassLoader classLoader;
    private final RuntimeOptions runtimeOptions;
    private final ResourceLoader resourceLoader;
    private final List<FeatureFile> featureFiles;

    public CucumberRunner(Class clazz) {
        logger.debug("init test class: {}", (Object)clazz);
        this.classLoader = clazz.getClassLoader();
        RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(clazz);
        this.runtimeOptions = runtimeOptionsFactory.create();
        this.resourceLoader = new MultiLoader(this.classLoader);
        List cfs = this.runtimeOptions.cucumberFeatures(this.resourceLoader);
        this.featureFiles = new ArrayList<FeatureFile>(cfs.size());
        for (CucumberFeature cf : cfs) {
            this.featureFiles.add(new FeatureFile(cf, new File(cf.getPath())));
        }
    }

    public CucumberRunner(File file) {
        logger.debug("init feature file: {}", (Object)file);
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.resourceLoader = new MultiLoader(this.classLoader);
        RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(this.getClass());
        this.runtimeOptions = runtimeOptionsFactory.create();
        FeatureWrapper wrapper = FeatureWrapper.fromFile(file, this.classLoader);
        CucumberFeature feature = wrapper.getFeature();
        FeatureFile featureFile = new FeatureFile(feature, file);
        this.featureFiles = Collections.singletonList(featureFile);
    }

    public List<CucumberFeature> getFeatures() {
        ArrayList<CucumberFeature> list = new ArrayList<CucumberFeature>(this.featureFiles.size());
        for (FeatureFile featureFile : this.featureFiles) {
            list.add(featureFile.feature);
        }
        return list;
    }

    public List<FeatureFile> getFeatureFiles() {
        return this.featureFiles;
    }

    public RuntimeOptions getRuntimeOptions() {
        return this.runtimeOptions;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Runtime getRuntime(CucumberFeature feature) {
        return this.getRuntime(new FeatureFile(feature, new File(feature.getPath())));
    }

    public Runtime getRuntime(FeatureFile featureFile) {
        String featurePath;
        File packageFile = featureFile.file;
        if (packageFile.exists()) {
            featurePath = packageFile.getAbsolutePath();
        } else {
            String temp = packageFile.getPath().replace('\\', '/');
            featurePath = this.classLoader.getResource(temp).getFile();
        }
        logger.debug("loading feature: {}", (Object)featurePath);
        File featureDir = new File(featurePath).getParentFile();
        ScriptEnv env = new ScriptEnv(null, featureDir, packageFile.getName(), this.classLoader);
        KarateBackend backend = new KarateBackend(env, null, null);
        RuntimeGlue glue = new RuntimeGlue(new UndefinedStepsTracker(), new LocalizedXStreams(this.classLoader));
        return new Runtime(this.resourceLoader, this.classLoader, Collections.singletonList(backend), this.runtimeOptions, StopWatch.SYSTEM, glue);
    }

    public void finish() {
        Formatter formatter = this.runtimeOptions.formatter(this.classLoader);
        formatter.done();
        formatter.close();
    }

    public void run(FeatureFile featureFile, KarateJunitFormatter formatter) {
        Runtime runtime = this.getRuntime(featureFile);
        featureFile.feature.run((Formatter)formatter, (Reporter)formatter, runtime);
    }

    public void run(KarateJunitFormatter formatter) {
        for (FeatureFile featureFile : this.getFeatureFiles()) {
            this.run(featureFile, formatter);
        }
    }

    private static KarateJunitFormatter getFormatter(String reportDirPath, FeatureFile featureFile) {
        String featurePackagePath;
        File reportDir = new File(reportDirPath);
        try {
            FileUtils.forceMkdirParent((File)reportDir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String featurePath = featureFile.feature.getPath();
        if (featurePath == null) {
            featurePath = featureFile.file.getPath();
        }
        if ((featurePackagePath = (featurePath = new File(featurePath).getPath()).replace(File.separator, ".")).endsWith(".feature")) {
            featurePackagePath = featurePackagePath.substring(0, featurePackagePath.length() - 8);
        }
        try {
            reportDirPath = reportDir.getPath() + File.separator;
            String reportPath = reportDirPath + "TEST-" + featurePackagePath + ".xml";
            return new KarateJunitFormatter(featurePackagePath, reportPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static KarateStats parallel(Class clazz, int threadCount) {
        return CucumberRunner.parallel(clazz, threadCount, "target/surefire-reports");
    }

    public static KarateStats parallel(Class clazz, int threadCount, String reportDir) {
        KarateStats stats = KarateStats.startTimer();
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        CucumberRunner runner = new CucumberRunner(clazz);
        List<FeatureFile> featureFiles = runner.getFeatureFiles();
        ArrayList<Callable<KarateJunitFormatter>> callables = new ArrayList<Callable<KarateJunitFormatter>>(featureFiles.size());
        int count = featureFiles.size();
        for (int i = 0; i < count; ++i) {
            int index = i + 1;
            FeatureFile featureFile = featureFiles.get(i);
            callables.add(() -> {
                String threadName = Thread.currentThread().getName();
                KarateJunitFormatter formatter = CucumberRunner.getFormatter(reportDir, featureFile);
                logger.info(">>>> feature {} of {} on thread {}: {}", new Object[]{index, count, threadName, featureFile.feature.getPath()});
                runner.run(featureFile, formatter);
                logger.info("<<<< feature {} of {} on thread {}: {}", new Object[]{index, count, threadName, featureFile.feature.getPath()});
                formatter.done();
                return formatter;
            });
        }
        try {
            List futures = executor.invokeAll(callables);
            stats.stopTimer();
            for (Future future : futures) {
                KarateJunitFormatter formatter = (KarateJunitFormatter)future.get();
                stats.addToTestCount(formatter.getTestCount());
                stats.addToFailCount(formatter.getFailCount());
                stats.addToSkipCount(formatter.getSkipCount());
                stats.addToTimeTaken(formatter.getTimeTaken());
                if (!formatter.isFail()) continue;
                stats.addToFailedList(formatter.getFeaturePath());
            }
            stats.printStats(threadCount);
            return stats;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

