/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cucumber;

import com.intuit.karate.KarateException;
import com.intuit.karate.ScriptContext;
import com.intuit.karate.ScriptEnv;
import com.intuit.karate.ScriptValueMap;
import com.intuit.karate.cucumber.FeatureSection;
import com.intuit.karate.cucumber.FeatureWrapper;
import com.intuit.karate.cucumber.KarateBackend;
import com.intuit.karate.cucumber.ScenarioOutlineWrapper;
import com.intuit.karate.cucumber.ScenarioWrapper;
import com.intuit.karate.cucumber.StepResult;
import com.intuit.karate.cucumber.StepWrapper;
import cucumber.runtime.FeatureBuilder;
import cucumber.runtime.Glue;
import cucumber.runtime.RuntimeGlue;
import cucumber.runtime.UndefinedStepsTracker;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.xstream.LocalizedXStreams;
import gherkin.formatter.Formatter;
import gherkin.parser.Parser;
import java.util.ArrayList;
import java.util.Map;

public class CucumberUtils {
    private CucumberUtils() {
    }

    public static KarateBackend getBackend(ScriptEnv env, ScriptContext parentContext, Map<String, Object> callArg) {
        KarateBackend backend = new KarateBackend(env, parentContext, callArg);
        ClassLoader defaultClassLoader = Thread.currentThread().getContextClassLoader();
        RuntimeGlue glue = new RuntimeGlue(new UndefinedStepsTracker(), new LocalizedXStreams(defaultClassLoader));
        backend.loadGlue((Glue)glue, null);
        return backend;
    }

    public static CucumberFeature parse(String text) {
        ArrayList features = new ArrayList();
        FeatureBuilder builder = new FeatureBuilder(features);
        Parser parser = new Parser((Formatter)builder);
        parser.parse(text, "", Integer.valueOf(0));
        CucumberFeature cucumberFeature = (CucumberFeature)features.get(0);
        cucumberFeature.setI18n(parser.getI18nLanguage());
        return cucumberFeature;
    }

    public static ScriptValueMap call(FeatureWrapper feature, ScriptContext parentContext, Map<String, Object> callArg) {
        ScriptEnv env = feature.getEnv();
        KarateBackend backend = CucumberUtils.getBackend(env, parentContext, callArg);
        for (FeatureSection section : feature.getSections()) {
            if (section.isOutline()) {
                ScenarioOutlineWrapper outline = section.getScenarioOutline();
                for (ScenarioWrapper scenario : outline.getScenarios()) {
                    CucumberUtils.call(scenario, backend);
                }
                continue;
            }
            CucumberUtils.call(section.getScenario(), backend);
        }
        return backend.getStepDefs().getContext().getVars();
    }

    private static void call(ScenarioWrapper scenario, KarateBackend backend) {
        for (StepWrapper step : scenario.getSteps()) {
            StepResult result = step.run(backend);
            if (result.isPass()) continue;
            ScriptEnv env = scenario.getFeature().getEnv();
            throw new KarateException("failed: " + env, result.getError());
        }
    }
}

