/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cucumber;

import com.intuit.karate.cucumber.FeatureSection;
import com.intuit.karate.cucumber.FeatureWrapper;
import com.intuit.karate.cucumber.ScenarioOutlineWrapper;
import com.intuit.karate.cucumber.StepWrapper;
import cucumber.runtime.model.CucumberBackground;
import cucumber.runtime.model.CucumberScenario;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.List;

public class ScenarioWrapper {
    private final int index;
    private final FeatureWrapper feature;
    private FeatureSection section;
    private final CucumberScenario scenario;
    private final ScenarioOutlineWrapper parent;
    private final List<StepWrapper> steps;

    public ScenarioWrapper(FeatureWrapper feature, int index, CucumberScenario scenario, ScenarioOutlineWrapper parent) {
        String priorText;
        this.feature = feature;
        this.index = index;
        this.scenario = scenario;
        this.parent = parent;
        this.steps = new ArrayList<StepWrapper>();
        CucumberBackground cucumberBackground = scenario.getCucumberBackground();
        int counter = 0;
        int currentLine = 0;
        if (cucumberBackground != null) {
            for (Step step : cucumberBackground.getSteps()) {
                priorText = feature.joinLines(currentLine, step.getLine() - 1);
                this.steps.add(new StepWrapper(this, counter++, priorText, step, true));
                currentLine = step.getLineRange().getLast();
            }
        }
        for (Step step : scenario.getSteps()) {
            priorText = feature.joinLines(currentLine, step.getLine() - 1);
            this.steps.add(new StepWrapper(this, counter++, priorText, step, false));
            currentLine = step.getLineRange().getLast();
        }
    }

    public void setSection(FeatureSection section) {
        this.section = section;
    }

    public FeatureSection getSection() {
        return this.section;
    }

    public int getIndex() {
        return this.index;
    }

    public List<StepWrapper> getSteps() {
        return this.steps;
    }

    public FeatureWrapper getFeature() {
        return this.feature;
    }

    public CucumberScenario getScenario() {
        return this.scenario;
    }

    public ScenarioOutlineWrapper getParent() {
        return this.parent;
    }

    public boolean isChild() {
        return this.parent != null;
    }

    public int getLine() {
        return this.scenario.getGherkinModel().getLine();
    }
}

