/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cucumber;

import com.intuit.karate.cucumber.FeatureWrapper;
import com.intuit.karate.cucumber.KarateBackend;
import com.intuit.karate.cucumber.ScenarioWrapper;
import com.intuit.karate.cucumber.StepResult;
import cucumber.runtime.Glue;
import cucumber.runtime.StepDefinitionMatch;
import cucumber.runtime.model.CucumberFeature;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Step;
import org.apache.commons.lang3.StringUtils;

public class StepWrapper {
    private final ScenarioWrapper scenario;
    private final int index;
    private final Step step;
    private final boolean background;
    private final String priorText;
    private Boolean pass;

    public StepWrapper(ScenarioWrapper scenario, int index, String priorText, Step step, boolean background) {
        this.scenario = scenario;
        this.index = index;
        this.priorText = StringUtils.trimToNull((String)priorText);
        this.background = background;
        this.step = step;
    }

    public void setPass(boolean passed) {
        this.pass = passed;
    }

    public Boolean isPass() {
        return this.pass;
    }

    public boolean isHttpCall() {
        String name = this.step.getName();
        return name.startsWith("method") || name.startsWith("soap");
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isBackground() {
        return this.background;
    }

    public boolean isPriorTextPresent() {
        return this.priorText != null;
    }

    public String getPriorText() {
        return this.priorText;
    }

    public int getPriorTextLineCount() {
        if (!this.isPriorTextPresent()) {
            return 0;
        }
        String[] split = this.priorText.split("\n");
        return split.length;
    }

    public Step getStep() {
        return this.step;
    }

    public int getStartLine() {
        return this.step.getLine() - 1;
    }

    public int getEndLine() {
        return this.step.getLineRange().getLast() - 1;
    }

    public ScenarioWrapper getScenario() {
        return this.scenario;
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.step.getKeyword());
        sb.append(this.step.getName());
        DocString docString = this.step.getDocString();
        if (docString != null) {
            sb.append("\n\"\"\"\n");
            sb.append(docString.getValue());
            sb.append("\n\"\"\"");
        }
        return sb.toString();
    }

    public boolean isOneLine() {
        return this.getStartLine() == this.getEndLine();
    }

    public int getLineCount() {
        if (this.isOneLine()) {
            return 1;
        }
        return this.getEndLine() - this.getStartLine();
    }

    public StepResult run(KarateBackend backend) {
        FeatureWrapper wrapper = this.scenario.getFeature();
        CucumberFeature feature = wrapper.getFeature();
        Glue glue = backend.getGlue();
        StepDefinitionMatch match = glue.stepDefinitionMatch("", this.step, feature.getI18n());
        try {
            match.runStep(feature.getI18n());
            return new StepResult(this, null);
        }
        catch (Throwable t) {
            wrapper.getEnv().logger.error("FAILED", t);
            return new StepResult(this, t);
        }
    }
}

