/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.KarateException;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptContext;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.http.Cookie;
import com.intuit.karate.http.HttpConfig;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.MultiPartItem;
import com.intuit.karate.http.MultiValuedMap;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.w3c.dom.Node;

public abstract class HttpClient<T> {
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String APPLICATION_XML = "application/xml";
    protected static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    protected static final String TEXT_PLAIN = "text/plain";
    protected static final String MULTIPART_FORM_DATA = "multipart/form-data";
    protected static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String KARATE_HTTP_PROPERTIES = "karate-http.properties";
    protected HttpRequest request;

    public abstract void configure(HttpConfig var1, ScriptContext var2);

    protected abstract T getEntity(List<MultiPartItem> var1, String var2);

    protected abstract T getEntity(MultiValuedMap var1, String var2);

    protected abstract T getEntity(InputStream var1, String var2);

    protected abstract T getEntity(String var1, String var2);

    protected abstract void buildUrl(String var1);

    protected abstract void buildPath(String var1);

    protected abstract void buildParam(String var1, Object ... var2);

    protected abstract void buildHeader(String var1, Object var2, boolean var3);

    protected abstract void buildCookie(Cookie var1);

    protected abstract HttpResponse makeHttpRequest(T var1, long var2);

    protected abstract String getRequestUri();

    private T getEntityInternal(ScriptValue body, String mediaType) {
        switch (body.getType()) {
            case JSON: {
                if (mediaType == null) {
                    mediaType = APPLICATION_JSON;
                }
                DocumentContext json = body.getValue(DocumentContext.class);
                return this.getEntity(json.jsonString(), mediaType);
            }
            case MAP: {
                if (mediaType == null) {
                    mediaType = APPLICATION_JSON;
                }
                Map map = body.getValue(Map.class);
                DocumentContext mapDoc = JsonPath.parse((Object)map);
                return this.getEntity(mapDoc.jsonString(), mediaType);
            }
            case LIST: {
                if (mediaType == null) {
                    mediaType = APPLICATION_JSON;
                }
                List list = body.getValue(List.class);
                DocumentContext listDoc = JsonPath.parse((Object)list);
                return this.getEntity(listDoc.jsonString(), mediaType);
            }
            case XML: {
                Node node = body.getValue(Node.class);
                if (mediaType == null) {
                    mediaType = APPLICATION_XML;
                }
                return this.getEntity(XmlUtils.toString(node), mediaType);
            }
            case INPUT_STREAM: {
                InputStream is = body.getValue(InputStream.class);
                if (mediaType == null) {
                    mediaType = APPLICATION_OCTET_STREAM;
                }
                return this.getEntity(is, mediaType);
            }
        }
        if (mediaType == null) {
            mediaType = TEXT_PLAIN;
        }
        return this.getEntity(body.getAsString(), mediaType);
    }

    /*
     * WARNING - void declaration
     */
    private T buildRequestInternal(HttpRequest request, ScriptContext context) {
        Map<String, Object> configuredHeaders;
        String method = request.getMethod();
        if (method == null) {
            String msg = "'method' is required to make an http call";
            context.logger.error(msg);
            throw new RuntimeException(msg);
        }
        method = method.toUpperCase();
        request.setMethod(method);
        this.request = request;
        String url = request.getUrl();
        if (url == null) {
            String msg = "url not set, please refer to the keyword documentation for 'url'";
            context.logger.error(msg);
            throw new RuntimeException(msg);
        }
        this.buildUrl(url);
        if (request.getPaths() != null) {
            for (String string : request.getPaths()) {
                this.buildPath(string);
            }
        }
        if (request.getParams() != null) {
            for (Map.Entry entry : request.getParams().entrySet()) {
                this.buildParam((String)entry.getKey(), ((List)entry.getValue()).toArray());
            }
        }
        if (request.getHeaders() != null) {
            for (Map.Entry entry : request.getHeaders().entrySet()) {
                for (Object value : (List)entry.getValue()) {
                    this.buildHeader((String)entry.getKey(), value, false);
                }
            }
        }
        if ((configuredHeaders = HttpClient.evalConfiguredHeaders(context)) != null) {
            for (Map.Entry<String, Object> entry : configuredHeaders.entrySet()) {
                this.buildHeader(entry.getKey(), entry.getValue(), true);
            }
        }
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies().values()) {
                this.buildCookie(cookie);
            }
        }
        if ("POST".equals(method) || "PUT".equals(method) || "PATCH".equals(method) || "DELETE".equals(method)) {
            String string = request.getContentType();
            if (request.getMultiPartItems() != null) {
                void var6_19;
                if (string == null) {
                    String string2 = MULTIPART_FORM_DATA;
                }
                return this.getEntity(request.getMultiPartItems(), (String)var6_19);
            }
            if (request.getFormFields() != null) {
                return this.getEntity(request.getFormFields(), APPLICATION_FORM_URLENCODED);
            }
            ScriptValue scriptValue = request.getBody();
            if (scriptValue == null || scriptValue.isNull()) {
                if ("DELETE".equals(method)) {
                    return null;
                }
                String msg = "request body is required for a " + method + ", please use the 'request' keyword";
                throw new RuntimeException(msg);
            }
            if (context.isLogPrettyRequest() && context.logger.isDebugEnabled()) {
                context.logger.debug("request:\n{}", (Object)scriptValue.getAsPrettyString());
            }
            return this.getEntityInternal(scriptValue, string);
        }
        return null;
    }

    protected static long getResponseTime(long startTime) {
        long endTime = System.currentTimeMillis();
        long responseTime = endTime - startTime;
        return responseTime;
    }

    public HttpResponse invoke(HttpRequest request, ScriptContext context) {
        T body = this.buildRequestInternal(request, context);
        long startTime = System.currentTimeMillis();
        try {
            HttpResponse response = this.makeHttpRequest(body, startTime);
            context.logger.debug("response time in milliseconds: {}", (Object)response.getTime());
            return response;
        }
        catch (Exception e) {
            long responseTime = HttpClient.getResponseTime(startTime);
            String message = "http call failed after " + responseTime + " milliseconds for URL: " + this.getRequestUri();
            context.logger.error(e.getMessage() + ", " + message);
            throw new KarateException(message, e);
        }
    }

    private static Map<String, Object> evalConfiguredHeaders(ScriptContext context) {
        ScriptValue headersValue = context.getConfiguredHeaders();
        switch (headersValue.getType()) {
            case JS_FUNCTION: {
                ScriptObjectMirror som = headersValue.getValue(ScriptObjectMirror.class);
                ScriptValue sv = Script.evalFunctionCall(som, null, context);
                switch (sv.getType()) {
                    case MAP: 
                    case JS_OBJECT: {
                        return sv.getValue(Map.class);
                    }
                }
                return null;
            }
            case JSON: {
                DocumentContext json = headersValue.getValue(DocumentContext.class);
                return (Map)json.read("$", new Predicate[0]);
            }
        }
        return null;
    }

    public static HttpClient construct() {
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(KARATE_HTTP_PROPERTIES);
            if (is == null) {
                String msg = "karate-http.properties not found";
                throw new RuntimeException(msg);
            }
            Properties props = new Properties();
            props.load(is);
            String className = props.getProperty("client.class");
            Class<?> clazz = Class.forName(className);
            return (HttpClient)clazz.newInstance();
        }
        catch (Exception e) {
            String msg = "failed to construct class by name: " + e.getMessage() + ", aborting";
            throw new RuntimeException(msg);
        }
    }
}

