/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.ScriptValue;
import com.intuit.karate.http.Cookie;
import com.intuit.karate.http.MultiPartItem;
import com.intuit.karate.http.MultiValuedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HttpRequest {
    private String url;
    private List<String> paths;
    private MultiValuedMap headers;
    private MultiValuedMap params;
    private Map<String, Cookie> cookies;
    private MultiValuedMap formFields;
    private List<MultiPartItem> multiPartItems;
    private ScriptValue body;
    private String method;
    private String soapAction;

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void addPath(String path) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(path);
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void removeHeader(String name) {
        if (this.headers == null) {
            return;
        }
        this.headers.remove(name);
    }

    public void setHeader(String name, String value) {
        this.setHeader(name, Collections.singletonList(value));
    }

    public void setHeader(String name, List<String> values) {
        if (this.headers == null) {
            this.headers = new MultiValuedMap();
        }
        this.headers.put(name, values);
    }

    public MultiValuedMap getHeaders() {
        return this.headers;
    }

    public void removeParam(String name) {
        if (this.params == null) {
            return;
        }
        this.params.remove(name);
    }

    public void setParam(String name, String value) {
        this.setParam(name, Collections.singletonList(value));
    }

    public void setParam(String name, List<String> values) {
        if (this.params == null) {
            this.params = new MultiValuedMap();
        }
        this.params.put(name, values);
    }

    public MultiValuedMap getParams() {
        return this.params;
    }

    public void removeCookie(String name) {
        if (this.cookies == null) {
            return;
        }
        this.cookies.remove(name);
    }

    public void setCookie(Cookie cookie) {
        if (this.cookies == null) {
            this.cookies = new LinkedHashMap<String, Cookie>();
        }
        this.cookies.put(cookie.getName(), cookie);
    }

    public Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    public void setCookies(Map<String, Cookie> cookies) {
        this.cookies = cookies;
    }

    public void removeFormField(String name) {
        if (this.formFields == null) {
            return;
        }
        this.formFields.remove(name);
    }

    public void setFormField(String name, String value) {
        this.setFormField(name, Collections.singletonList(value));
    }

    public void setFormField(String name, List<String> values) {
        if (this.formFields == null) {
            this.formFields = new MultiValuedMap();
        }
        this.formFields.put(name, values);
    }

    public MultiValuedMap getFormFields() {
        return this.formFields;
    }

    public void addMultiPartItem(String name, ScriptValue value) {
        if (this.multiPartItems == null) {
            this.multiPartItems = new ArrayList<MultiPartItem>();
        }
        this.multiPartItems.add(new MultiPartItem(name, value));
    }

    public List<MultiPartItem> getMultiPartItems() {
        return this.multiPartItems;
    }

    public ScriptValue getBody() {
        return this.body;
    }

    public void setBody(ScriptValue body) {
        this.body = body;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public String getContentType() {
        if (this.headers == null) {
            return null;
        }
        Object contentType = this.headers.getFirst("Content-Type");
        if (contentType == null) {
            return null;
        }
        return contentType.toString();
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public String getSoapAction() {
        return this.soapAction;
    }
}

