/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.validator;

import com.intuit.karate.ScriptValue;
import com.intuit.karate.validator.ValidationResult;
import com.intuit.karate.validator.Validator;
import com.jayway.jsonpath.DocumentContext;

public class ObjectValidator
implements Validator {
    public static final ObjectValidator INSTANCE = new ObjectValidator();

    @Override
    public ValidationResult validate(ScriptValue value) {
        switch (value.getType()) {
            case JSON: {
                DocumentContext doc = value.getValue(DocumentContext.class);
                if (!doc.jsonString().startsWith("{")) {
                    return ValidationResult.fail("not a json object");
                }
                return ValidationResult.PASS;
            }
            case JS_OBJECT: 
            case MAP: {
                return ValidationResult.PASS;
            }
        }
        return ValidationResult.fail("not a json object");
    }
}

