/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.plugins.unleash.ReleasePhase;
import com.itemis.maven.plugins.unleash.util.ReleaseUtil;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToCoordinates;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;

@Singleton
public class ReleaseMetadata {
    @Inject
    private MavenProject project;
    @Inject
    private PluginParameterExpressionEvaluator expressionEvaluator;
    @Inject
    @Named(value="tagNamePattern")
    private String tagNamePattern;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;
    private String initialScmRevision;
    private String scmRevisionBeforeNextDevVersion;
    private String scmRevisionAfterNextDevVersion;
    private String scmRevisionBeforeTag;
    private String scmRevisionAfterTag;
    private Map<ReleasePhase, Set<ArtifactCoordinates>> artifactCoordinates;
    private String scmTagName;
    private RemoteRepository deploymentRepository;
    private Set<Artifact> releaseArtifacts;
    private Map<ArtifactCoordinates, Scm> cachedScmSettings;

    private ReleaseMetadata() {
        int numPhases = ReleasePhase.values().length;
        this.artifactCoordinates = Maps.newHashMapWithExpectedSize((int)numPhases);
        for (ReleasePhase phase : ReleasePhase.values()) {
            this.artifactCoordinates.put(phase, Sets.newHashSet());
        }
        this.cachedScmSettings = Maps.newHashMap();
    }

    @PostConstruct
    public void init() {
        org.apache.maven.artifact.Artifact projectArtifact = this.project.getArtifact();
        String oldVersion = projectArtifact.getVersion();
        projectArtifact.setVersion("1");
        this.deploymentRepository = RepositoryUtils.toRepo((ArtifactRepository)this.project.getDistributionManagementArtifactRepository());
        projectArtifact.setVersion(oldVersion);
        for (MavenProject p : this.reactorProjects) {
            this.addArtifactCoordinates(ProjectToCoordinates.POM.apply(p), ReleasePhase.PRE_RELEASE);
            this.cachedScmSettings.put(ProjectToCoordinates.EMPTY_VERSION.apply(p), p.getModel().getScm());
        }
    }

    public void setInitialScmRevision(String scmRevision) {
        this.initialScmRevision = scmRevision;
    }

    public String getInitialScmRevision() {
        return this.initialScmRevision;
    }

    public void setScmRevisionBeforeNextDevVersion(String scmRevisionBeforeNextDevVersion) {
        this.scmRevisionBeforeNextDevVersion = scmRevisionBeforeNextDevVersion;
    }

    public String getScmRevisionBeforeNextDevVersion() {
        return this.scmRevisionBeforeNextDevVersion;
    }

    public void setScmRevisionAfterNextDevVersion(String scmRevisionAfterNextDevVersion) {
        this.scmRevisionAfterNextDevVersion = scmRevisionAfterNextDevVersion;
    }

    public String getScmRevisionAfterNextDevVersion() {
        return this.scmRevisionAfterNextDevVersion;
    }

    public void setScmRevisionBeforeTag(String scmRevisionBeforeTag) {
        this.scmRevisionBeforeTag = scmRevisionBeforeTag;
    }

    public String getScmRevisionBeforeTag() {
        return this.scmRevisionBeforeTag;
    }

    public void setScmRevisionAfterTag(String scmRevisionAfterTag) {
        this.scmRevisionAfterTag = scmRevisionAfterTag;
    }

    public String getScmRevisionAfterTag() {
        return this.scmRevisionAfterTag;
    }

    public void addArtifactCoordinates(ArtifactCoordinates coordinates, ReleasePhase phase) {
        this.artifactCoordinates.get((Object)phase).add(coordinates);
    }

    public Map<ReleasePhase, ArtifactCoordinates> getArtifactCoordinatesByPhase(String groupId, String artifactId) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)this.artifactCoordinates.size());
        block0: for (ReleasePhase phase : this.artifactCoordinates.keySet()) {
            for (ArtifactCoordinates coordinates : this.artifactCoordinates.get((Object)phase)) {
                if (!Objects.equal((Object)coordinates.getArtifactId(), (Object)artifactId) || !Objects.equal((Object)coordinates.getGroupId(), (Object)groupId)) continue;
                result.put(phase, coordinates);
                continue block0;
            }
        }
        return result;
    }

    public String getScmTagName() {
        if (this.scmTagName == null) {
            this.scmTagName = ReleaseUtil.getTagName(this.tagNamePattern, this.project, this.expressionEvaluator);
        }
        return this.scmTagName;
    }

    public RemoteRepository getDeploymentRepository() {
        return this.deploymentRepository;
    }

    public void addReleaseArtifact(Artifact artifact) {
        if (this.releaseArtifacts == null) {
            this.releaseArtifacts = Sets.newHashSet();
        }
        this.releaseArtifacts.add(artifact);
    }

    public Set<Artifact> getReleaseArtifacts() {
        return this.releaseArtifacts;
    }

    public Scm getCachedScmSettings(MavenProject p) {
        return this.cachedScmSettings.get(ProjectToCoordinates.EMPTY_VERSION.apply(p));
    }
}

