/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.plugins.cdi.AbstractCDIMojo;
import com.itemis.maven.plugins.cdi.annotations.MojoInject;
import com.itemis.maven.plugins.cdi.annotations.MojoProduces;
import com.itemis.maven.plugins.unleash.util.VersionUpgradeStrategy;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import org.apache.commons.logging.Log;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="perform-tycho", aggregator=true, requiresProject=true)
public class UnleashTychoMojo
extends AbstractCDIMojo {
    @MojoProduces
    @Component
    private PlexusContainer plexus;
    @MojoProduces
    @Component
    private RepositorySystem repoSystem;
    @MojoProduces
    @Component
    private RemoteRepositoryManager remoteRepositoryManager;
    @MojoProduces
    @Component
    private Deployer deployer;
    @MojoProduces
    @Component
    private Installer installer;
    @MojoProduces
    @Component
    private Prompter prompter;
    @MojoProduces
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @MojoProduces
    @Parameter(property="mojoExecution", readonly=true)
    private MojoExecution mojoExecution;
    @MojoProduces
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repoSession;
    @MojoProduces
    @Named(value="pluginRepositories")
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true, required=true)
    private List<RemoteRepository> remotePluginRepos;
    @MojoProduces
    @Named(value="projectRepositories")
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> remoteProjectRepos;
    @MojoProduces
    @Named(value="local")
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository LocalRepository;
    @MojoProduces
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @MojoProduces
    @Named(value="reactorProjects")
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @MojoProduces
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @MojoProduces
    @Named(value="allowLocalReleaseArtifacts")
    @Parameter(defaultValue="true", property="unleash.allowLocalReleaseArtifacts", required=true)
    private boolean allowLocalReleaseArtifacts;
    @MojoProduces
    @Named(value="commitBeforeTagging")
    @Parameter(defaultValue="false", property="unleash.commitBeforeTagging", required=true)
    private boolean commitBeforeTagging;
    @MojoProduces
    @Named(value="maven.home")
    @Parameter(defaultValue="${maven.home}", property="unleash.mavenHome", required=true)
    private String mavenHome;
    @MojoProduces
    @Named(value="tagNamePattern")
    @Parameter(defaultValue="@{project.version}", property="unleash.tagNamePattern", required=true)
    private String tagNamePattern;
    @MojoProduces
    @Named(value="developmentVersion")
    @Parameter(property="unleash.developmentVersion", required=false)
    private String developmentVersion;
    @MojoProduces
    @Named(value="profiles")
    @Parameter(property="unleash.profiles", required=false)
    private List<String> profiles;
    @Parameter(defaultValue="", property="unleash.releaseArgs", required=false)
    private List<String> releaseArgs;
    @MojoProduces
    @Named(value="releaseVersion")
    @Parameter(property="unleash.releaseVersion", required=false)
    private String releaseVersion;
    @Parameter(defaultValue="[unleash-maven-plugin]", property="unleash.scmMessagePrefix", required=false)
    private String scmMessagePrefix;
    @MojoProduces
    @Named(value="scmPassword")
    @Parameter(property="unleash.scmPassword", required=false)
    private String scmPassword;
    @MojoProduces
    @Named(value="scmUsername")
    @Parameter(property="unleash.scmUsername", required=false)
    private String scmUsername;
    @MojoProduces
    @Named(value="scmSshPassphrase")
    @Parameter(property="unleash.scmSshPassphrase", required=false)
    private String scmSshPassphrase;
    @MojoProduces
    @Named(value="scmPasswordEnvVar")
    @Parameter(property="unleash.scmPasswordEnvVar", required=false)
    private String scmPasswordEnvVar;
    @MojoProduces
    @Named(value="scmUsernameEnvVar")
    @Parameter(property="unleash.scmUsernameEnvVar", required=false)
    private String scmUsernameEnvVar;
    @MojoProduces
    @Named(value="scmSshPassphraseEnvVar")
    @Parameter(property="unleash.scmSshPassphraseEnvVar", required=false)
    private String scmSshPassphraseEnvVar;
    @Parameter(property="unleash.releaseEnvironment", required=false)
    private String releaseEnvironmentVariables;
    @MojoProduces
    @Parameter(property="unleash.versionUpgradeStrategy", required=true, defaultValue="DEFAULT")
    private VersionUpgradeStrategy versionUpgradeStrategy;
    @MojoProduces
    @Named(value="artifactSpyPlugin")
    private ArtifactCoordinates artifactSpyPluginCoordinates = new ArtifactCoordinates("com.itemis.maven.plugins", "artifact-spy-plugin", "1.0.6", "maven-plugin");

    @MojoProduces
    private PluginParameterExpressionEvaluator getExpressionEvaluator() {
        return new PluginParameterExpressionEvaluator(this.session, this.mojoExecution);
    }

    @MojoProduces
    private PluginDescriptor getPluginDescriptor() {
        return (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
    }

    @MojoProduces
    @Named(value="scmMessagePrefix")
    private String getScmMessagePrefix() {
        if (this.scmMessagePrefix != null && !this.scmMessagePrefix.endsWith(" ")) {
            this.scmMessagePrefix = this.scmMessagePrefix + " ";
        }
        return Strings.nullToEmpty((String)this.scmMessagePrefix);
    }

    @MojoProduces
    @Named(value="unleashOutputFolder")
    private File getUnleashOutputFolder() {
        File folder = new File(this.project.getBuild().getDirectory(), "unleash");
        folder.mkdirs();
        return folder;
    }

    @MojoProduces
    @Named(value="releaseArgs")
    @MojoInject
    private Properties getReleaseArgs(Log log) {
        Properties args = new Properties();
        Splitter splitter = Splitter.on((char)'=');
        for (String arg : this.releaseArgs) {
            List split = splitter.splitToList((CharSequence)arg);
            if (split.size() == 2) {
                args.put(split.get(0), split.get(1));
                continue;
            }
            log.warn((Object)("Could not set '" + arg + "' as a Property for the Maven release build."));
        }
        return args;
    }

    @MojoProduces
    @Named(value="releaseEnvVariables")
    private Map<String, String> getReleaseEnvironmentVariables() {
        HashMap env = Maps.newHashMap();
        if (!Strings.isNullOrEmpty((String)this.releaseEnvironmentVariables)) {
            Iterable split = Splitter.on((char)',').split((CharSequence)this.releaseEnvironmentVariables);
            for (String token : split) {
                String date = Strings.emptyToNull((String)token.trim());
                if (date == null) continue;
                List dataSplit = Splitter.on((String)"=>").splitToList((CharSequence)date);
                String key = (String)dataSplit.get(0);
                String value = (String)dataSplit.get(1);
                env.put(key, value);
            }
        }
        return env;
    }
}

