/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.actions;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.annotations.RollbackOnError;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.util.ReleaseUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.DefaultSettingsWriter;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.util.cli.CommandLineException;

@ProcessingStep(id="buildReleaseArtifacts", description="Triggers the atual release build which produces the release artifacts but does not install or deploy them.", requiresOnline=true)
public class BuildProject
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    private MavenProject project;
    @Inject
    @Named(value="profiles")
    private List<String> profiles;
    @Inject
    @Named(value="maven.home")
    private String mavenHome;
    @Inject
    private Settings settings;
    @Inject
    @Named(value="releaseArgs")
    private Properties releaseArgs;
    @Inject
    @Named(value="unleashOutputFolder")
    private File unleashOutputFolder;
    @Inject
    @Named(value="releaseEnvVariables")
    private Map<String, String> releaseEnvironmentVariables;
    private File tempSettingsFile;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"Starting release build.");
        try {
            InvocationRequest request = this.setupInvocationRequest();
            Invoker invoker = this.setupInvoker();
            InvocationResult result = invoker.execute(request);
            if (result.getExitCode() != 0) {
                CommandLineException executionException = result.getExecutionException();
                if (executionException != null) {
                    throw new MojoFailureException("Error during project build: " + executionException.getMessage(), (Throwable)executionException);
                }
                throw new MojoFailureException("Error during project build: " + result.getExitCode());
            }
        }
        catch (MavenInvocationException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.deleteTempSettings();
        }
    }

    private Invoker setupInvoker() {
        DefaultInvoker invoker = new DefaultInvoker();
        File calculatedMavenHome = ReleaseUtil.getMavenHome((Optional<String>)Optional.fromNullable((Object)this.mavenHome));
        if (calculatedMavenHome != null) {
            this.log.debug((CharSequence)("\tUsing maven home: " + calculatedMavenHome.getAbsolutePath()));
            invoker.setMavenHome(calculatedMavenHome);
        }
        return invoker;
    }

    private InvocationRequest setupInvocationRequest() throws MojoExecutionException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(this.project.getFile());
        request.setGoals((List)Lists.newArrayList((Object[])new String[]{"clean", "verify"}));
        request.setProperties(this.releaseArgs);
        request.setProfiles(this.profiles);
        request.setShellEnvironmentInherited(true);
        for (String key : this.releaseEnvironmentVariables.keySet()) {
            request.addShellEnvironment(key, this.releaseEnvironmentVariables.get(key));
        }
        request.setOffline(this.settings.isOffline());
        request.setInteractive(this.settings.isInteractiveMode());
        this.tempSettingsFile = this.createAndSetTempSettings((InvocationRequest)request);
        return request;
    }

    private File createAndSetTempSettings(InvocationRequest request) throws MojoExecutionException {
        DefaultSettingsWriter settingsWriter = new DefaultSettingsWriter();
        File settingsFile = new File(this.unleashOutputFolder, "settings.xml");
        try {
            settingsWriter.write(settingsFile, null, this.settings);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to store Maven settings for release build", (Exception)e);
        }
        request.setUserSettingsFile(settingsFile);
        return settingsFile;
    }

    private void deleteTempSettings() {
        if (this.tempSettingsFile != null && this.tempSettingsFile.exists()) {
            this.tempSettingsFile.delete();
            this.tempSettingsFile = null;
        }
    }

    @RollbackOnError
    public void rollback() {
        this.deleteTempSettings();
    }
}

