/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.actions;

import com.google.common.collect.Maps;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.annotations.RollbackOnError;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.ReleaseMetadata;
import com.itemis.maven.plugins.unleash.ReleasePhase;
import com.itemis.maven.plugins.unleash.scm.ScmProvider;
import com.itemis.maven.plugins.unleash.scm.merge.MergeClient;
import com.itemis.maven.plugins.unleash.scm.requests.RevertCommitsRequest;
import com.itemis.maven.plugins.unleash.util.DevVersionUtil;
import com.itemis.maven.plugins.unleash.util.PomUtil;
import com.itemis.maven.plugins.unleash.util.VersionUpgradeStrategy;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToCoordinates;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToString;
import com.itemis.maven.plugins.unleash.util.scm.ScmPomVersionsMergeClient;
import com.itemis.maven.plugins.unleash.util.scm.ScmProviderRegistry;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;

@ProcessingStep(id="setDevVersion", description="Updates the projects with the next development versions, reverts previous SCM path changes and finally commits the changes to the current branch.", requiresOnline=true)
public class SetNextDevVersion
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    private ReleaseMetadata metadata;
    @Inject
    MavenProject project;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Inject
    private ScmProviderRegistry scmProviderRegistry;
    @Inject
    @Named(value="scmMessagePrefix")
    private String scmMessagePrefix;
    @Inject
    private DevVersionUtil util;
    @Inject
    private VersionUpgradeStrategy versionUpgradeStrategy;
    private ScmProvider scmProvider;
    private Map<ArtifactCoordinates, Document> cachedPOMs;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"Preparing project modules for next development cycle.");
        this.scmProvider = this.scmProviderRegistry.getProvider();
        this.cachedPOMs = Maps.newHashMap();
        for (MavenProject project : this.reactorProjects) {
            this.log.debug((CharSequence)("\tPreparing module '" + ProjectToString.INSTANCE.apply(project) + "'."));
            this.cachedPOMs.put(ProjectToCoordinates.EMPTY_VERSION.apply(project), PomUtil.parsePOM(project));
            try {
                Document document = PomUtil.parsePOM(project);
                this.setProjectVersion(project, document);
                this.setParentVersion(project, document);
                this.util.revertScmSettings(project, document);
                PomUtil.writePOM(document, project);
            }
            catch (Throwable t) {
                throw new MojoFailureException("Could not update versions for next development cycle.", t);
            }
        }
        this.util.commitChanges(true);
    }

    private void setProjectVersion(MavenProject project, Document document) {
        Map<ReleasePhase, ArtifactCoordinates> coordinatesByPhase = this.metadata.getArtifactCoordinatesByPhase(project.getGroupId(), project.getArtifactId());
        String oldVerion = coordinatesByPhase.get((Object)ReleasePhase.RELEASE).getVersion();
        String newVersion = coordinatesByPhase.get((Object)ReleasePhase.POST_RELEASE).getVersion();
        this.log.debug((CharSequence)("\t\tUpdate of module version '" + project.getGroupId() + ":" + project.getArtifact() + "' [" + oldVerion + " => " + newVersion + "] Version Upgrade Strategy: " + this.versionUpgradeStrategy.name()));
        PomUtil.setProjectVersion(project.getModel(), document, newVersion);
    }

    private void setParentVersion(MavenProject project, Document document) {
        Parent parent = project.getModel().getParent();
        if (parent != null) {
            Map<ReleasePhase, ArtifactCoordinates> coordinatesByPhase = this.metadata.getArtifactCoordinatesByPhase(parent.getGroupId(), parent.getArtifactId());
            ArtifactCoordinates oldCoordinates = coordinatesByPhase.get((Object)ReleasePhase.RELEASE);
            ArtifactCoordinates newCoordinates = coordinatesByPhase.get((Object)ReleasePhase.POST_RELEASE);
            if (newCoordinates != null) {
                this.log.debug((CharSequence)("\t\tUpdate of parent version of module '" + project.getGroupId() + ":" + project.getArtifact() + "' [" + oldCoordinates.getVersion() + " => " + newCoordinates.getVersion() + "]"));
                PomUtil.setParentVersion(project.getModel(), document, newCoordinates.getVersion());
            }
        }
    }

    @RollbackOnError
    public void rollback() throws MojoExecutionException {
        this.log.info((CharSequence)"Rollback of all pom changes necessary for setting of the development version as well as reverting any made SCM commits.");
        StringBuilder message = new StringBuilder("Reversion of failed release build (step: setting of next snapshot version).");
        if (StringUtils.isNotBlank((CharSequence)this.scmMessagePrefix)) {
            message.insert(0, this.scmMessagePrefix);
        }
        if (this.metadata.getScmRevisionAfterNextDevVersion() != null) {
            RevertCommitsRequest revertCommitsRequest = RevertCommitsRequest.builder().fromRevision(this.metadata.getScmRevisionAfterNextDevVersion()).toRevision(this.metadata.getScmRevisionBeforeNextDevVersion()).message(message.toString()).merge().mergeClient((MergeClient)new ScmPomVersionsMergeClient()).push().build();
            this.scmProvider.revertCommits(revertCommitsRequest);
        }
        for (MavenProject project : this.reactorProjects) {
            Document document = this.cachedPOMs.get(ProjectToCoordinates.EMPTY_VERSION.apply(project));
            if (document == null) continue;
            try {
                PomUtil.writePOM(document, this.project);
            }
            catch (Throwable t) {
                throw new MojoExecutionException("Could not revert the setting of development versions after a failed release build.", t);
            }
        }
    }
}

