/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.actions;

import com.google.common.collect.Maps;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.annotations.RollbackOnError;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.ReleaseMetadata;
import com.itemis.maven.plugins.unleash.ReleasePhase;
import com.itemis.maven.plugins.unleash.util.PomUtil;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToCoordinates;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToString;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;

@ProcessingStep(id="setReleaseVersions", description="Updates the POMs of all project modules with their release versions calculated previously.", requiresOnline=false)
public class SetReleaseVersions
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    private ReleaseMetadata metadata;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;
    private Map<ArtifactCoordinates, Document> cachedPOMs;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"Updating project modules with release versions");
        this.cachedPOMs = Maps.newHashMap();
        for (MavenProject project : this.reactorProjects) {
            this.cachedPOMs.put(ProjectToCoordinates.EMPTY_VERSION.apply(project), PomUtil.parsePOM(project));
            try {
                Document document = PomUtil.parsePOM(project);
                this.setProjectVersion(project, document);
                this.setParentVersion(project, document);
                PomUtil.writePOM(document, project);
            }
            catch (Throwable t) {
                throw new MojoFailureException("Could not update versions for release.", t);
            }
        }
    }

    private void setProjectVersion(MavenProject project, Document document) {
        Map<ReleasePhase, ArtifactCoordinates> coordinatesByPhase = this.metadata.getArtifactCoordinatesByPhase(project.getGroupId(), project.getArtifactId());
        String oldVerion = coordinatesByPhase.get((Object)ReleasePhase.PRE_RELEASE).getVersion();
        String newVersion = coordinatesByPhase.get((Object)ReleasePhase.RELEASE).getVersion();
        this.log.debug((CharSequence)("\tUpdate of module version '" + project.getGroupId() + ":" + project.getArtifact() + "' [" + oldVerion + " => " + newVersion + "]"));
        PomUtil.setProjectVersion(project.getModel(), document, newVersion);
    }

    private void setParentVersion(MavenProject project, Document document) {
        Parent parent = project.getModel().getParent();
        if (parent != null) {
            Map<ReleasePhase, ArtifactCoordinates> coordinatesByPhase = this.metadata.getArtifactCoordinatesByPhase(parent.getGroupId(), parent.getArtifactId());
            ArtifactCoordinates oldCoordinates = coordinatesByPhase.get((Object)ReleasePhase.PRE_RELEASE);
            ArtifactCoordinates newCoordinates = coordinatesByPhase.get((Object)ReleasePhase.RELEASE);
            if (newCoordinates != null) {
                this.log.debug((CharSequence)("\tUpdate of parent version of module '" + project.getGroupId() + ":" + project.getArtifact() + "' [" + oldCoordinates.getVersion() + " => " + newCoordinates.getVersion() + "]"));
                PomUtil.setParentVersion(project.getModel(), document, newCoordinates.getVersion());
            }
        }
    }

    @RollbackOnError
    public void rollback() throws MojoExecutionException {
        this.log.info((CharSequence)"Rollback of release version updating for all project modules");
        for (MavenProject project : this.reactorProjects) {
            this.log.debug((CharSequence)("\tRolling back modifications on POM of module '" + ProjectToString.INSTANCE.apply(project) + "'"));
            Document document = this.cachedPOMs.get(ProjectToCoordinates.EMPTY_VERSION.apply(project));
            if (document == null) continue;
            try {
                PomUtil.writePOM(document, project);
            }
            catch (Throwable t) {
                throw new MojoExecutionException("Could not revert the setting of release versions after a failed release build.", t);
            }
        }
    }
}

