/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.util;

import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.ReleaseMetadata;
import com.itemis.maven.plugins.unleash.scm.ScmProvider;
import com.itemis.maven.plugins.unleash.scm.merge.MergeClient;
import com.itemis.maven.plugins.unleash.scm.requests.CommitRequest;
import com.itemis.maven.plugins.unleash.util.PomUtil;
import com.itemis.maven.plugins.unleash.util.functions.FileToRelativePath;
import com.itemis.maven.plugins.unleash.util.scm.ScmPomVersionsMergeClient;
import com.itemis.maven.plugins.unleash.util.scm.ScmProviderRegistry;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DevVersionUtil {
    @Inject
    private Logger log;
    @Inject
    private MavenProject project;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Inject
    private ReleaseMetadata metadata;
    @Inject
    @Named(value="scmMessagePrefix")
    private String scmMessagePrefix;
    @Inject
    private ScmProviderRegistry scmProviderRegistry;
    private ScmProvider scmProvider;

    @PostConstruct
    private void init() {
        this.scmProvider = this.scmProviderRegistry.getProvider();
    }

    public void revertScmSettings(MavenProject projectToRevert, Document document) {
        Scm scm = this.metadata.getCachedScmSettings(projectToRevert);
        if (scm != null) {
            this.log.debug((CharSequence)"\t\tReversion of SCM connection tags");
            Node scmNode = PomUtil.getOrCreateScmNode(document, false);
            if (scmNode != null) {
                if (scm.getConnection() != null) {
                    PomUtil.setNodeTextContent(scmNode, "connection", scm.getConnection(), false);
                }
                if (scm.getDeveloperConnection() != null) {
                    PomUtil.setNodeTextContent(scmNode, "developerConnection", scm.getDeveloperConnection(), false);
                }
                if (scm.getUrl() != null) {
                    PomUtil.setNodeTextContent(scmNode, "url", scm.getUrl(), false);
                }
                if (scm.getTag() != null) {
                    PomUtil.setNodeTextContent(scmNode, "tag", scm.getTag(), false);
                } else {
                    PomUtil.deleteNode(scmNode, "tag");
                }
            }
        }
    }

    public void commitChanges(boolean commitPomsOnly) {
        this.log.debug((CharSequence)"\tCommitting changed POMs of all modules and pushing to remote repository. Merging with remote changes if necessary.");
        this.metadata.setScmRevisionBeforeNextDevVersion(this.scmProvider.getLatestRemoteRevision());
        StringBuilder message = new StringBuilder("Preparation for next development cycle.");
        if (StringUtils.isNotBlank((CharSequence)this.scmMessagePrefix)) {
            message.insert(0, this.scmMessagePrefix);
        }
        CommitRequest.Builder requestBuilder = CommitRequest.builder().merge().mergeClient((MergeClient)new ScmPomVersionsMergeClient()).message(message.toString()).push();
        FileToRelativePath pathConverter = new FileToRelativePath(this.project.getBasedir());
        if (commitPomsOnly) {
            for (MavenProject p : this.reactorProjects) {
                requestBuilder.addPaths(new String[]{pathConverter.apply(p.getFile())});
            }
        }
        String newRevision = this.scmProvider.commit(requestBuilder.build());
        this.metadata.setScmRevisionAfterNextDevVersion(newRevision);
    }
}

