/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.util;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;

public class PomPropertyResolver {
    private MavenProject project;
    private Map<String, String> properties;

    public PomPropertyResolver(MavenProject project) {
        this.project = project;
    }

    public Map<String, String> getProperties() {
        this.resolveAllProperties();
        return this.properties;
    }

    public String getProperty(String key) {
        this.resolveAllProperties();
        return this.properties.get(key);
    }

    public String expandPropertyReferences(String s) {
        this.resolveAllProperties();
        return this.resolveReferences(s);
    }

    private void resolveAllProperties() {
        if (this.properties != null) {
            return;
        }
        this.properties = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : this.project.getProperties().entrySet()) {
            this.properties.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Profile profile : this.project.getModel().getProfiles()) {
            for (Map.Entry<Object, Object> entry : profile.getProperties().entrySet()) {
                this.properties.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.properties.put("project.version", this.project.getVersion());
        for (Map.Entry<Object, Object> entry : System.getenv().entrySet()) {
            this.properties.put("env." + (String)entry.getKey(), (String)entry.getValue());
        }
        for (String string : this.properties.keySet()) {
            this.properties.put(string, this.resolveProperty(string));
        }
    }

    private String resolveProperty(String key) {
        String value = this.properties.get(key);
        return this.resolveReferences(value);
    }

    private String resolveReferences(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder currentKey = null;
        boolean isRef = false;
        block5: for (char c : s.toCharArray()) {
            switch (c) {
                case '$': {
                    isRef = true;
                    currentKey = new StringBuilder();
                    continue block5;
                }
                case '{': {
                    if (isRef) continue block5;
                    sb.append(c);
                    continue block5;
                }
                case '}': {
                    if (isRef) {
                        sb.append((String)MoreObjects.firstNonNull((Object)this.resolveProperty(currentKey.toString()), (Object)("${" + currentKey.toString() + "}")));
                        currentKey = null;
                        isRef = false;
                        continue block5;
                    }
                    sb.append(c);
                    continue block5;
                }
                default: {
                    if (isRef) {
                        currentKey.append(c);
                        continue block5;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

