/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.util;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToString;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class PomUtil {
    public static final String ARTIFACT_TYPE_JAR = "jar";
    public static final String ARTIFACT_TYPE_POM = "pom";
    public static final String VERSION_QUALIFIER_SNAPSHOT = "-SNAPSHOT";
    public static final String VERSION_LATEST = "LATEST";
    public static final String NODE_NAME_ARTIFACT_ID = "artifactId";
    public static final String NODE_NAME_BUILD = "build";
    public static final String NODE_NAME_EXECUTION = "execution";
    public static final String NODE_NAME_EXECUTIONS = "executions";
    public static final String NODE_NAME_GOAL = "goal";
    public static final String NODE_NAME_GOALS = "goals";
    public static final String NODE_NAME_GROUP_ID = "groupId";
    public static final String NODE_NAME_ID = "id";
    public static final String NODE_NAME_PARENT = "parent";
    public static final String NODE_NAME_PHASE = "phase";
    public static final String NODE_NAME_PLUGIN = "plugin";
    public static final String NODE_NAME_PLUGINS = "plugins";
    public static final String NODE_NAME_PROJECT = "project";
    public static final String NODE_NAME_SCM = "scm";
    public static final String NODE_NAME_SCM_CONNECTION = "connection";
    public static final String NODE_NAME_SCM_DEV_CONNECTION = "developerConnection";
    public static final String NODE_NAME_SCM_TAG = "tag";
    public static final String NODE_NAME_SCM_URL = "url";
    public static final String NODE_NAME_VERSION = "version";

    private PomUtil() {
    }

    public static final Document parsePOM(MavenProject project) {
        try {
            return PomUtil.parsePOM(project.getFile());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Could not load the project object model of the following module: " + ProjectToString.INSTANCE.apply(project), e);
        }
    }

    public static final Document parsePOM(File pomFile) {
        Preconditions.checkArgument((pomFile != null && pomFile.exists() && pomFile.isFile() ? 1 : 0) != 0, (Object)"The project file does not exist or is invalid.");
        try {
            return PomUtil.parsePOM(new FileInputStream(pomFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not load the project object model from file: " + pomFile.getAbsolutePath(), e);
        }
    }

    public static final Document parsePOM(InputStream in) {
        try {
            Document document;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document2 = document = documentBuilder.parse(in);
            return document2;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load the project object model from input stream.", e);
        }
        finally {
            Closeables.closeQuietly((InputStream)in);
        }
    }

    public static final void writePOM(Document document, MavenProject project) {
        File pom = project.getFile();
        Preconditions.checkArgument((pom != null && pom.exists() && pom.isFile() ? 1 : 0) != 0, (Object)"The passed project does not contain a valid POM file reference.");
        try {
            PomUtil.writePOM(document, new FileOutputStream(pom), true);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not serialize the project object model of the following module: " + ProjectToString.INSTANCE.apply(project), t);
        }
    }

    public static final void writePOM(Document document, OutputStream out, boolean closeOut) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(document);
            transformer.transform(source, new StreamResult(out));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not serialize the project object model to given output stream.", e);
        }
        finally {
            if (closeOut) {
                try {
                    Closeables.close((Closeable)out, (boolean)true);
                }
                catch (IOException e) {
                    throw new RuntimeException("Actually this should not happen :(", e);
                }
            }
        }
    }

    public static void setProjectVersion(Model model, Document document, String newVersion) {
        Preconditions.checkArgument((boolean)PomUtil.hasChildNode(document, NODE_NAME_PROJECT), (Object)"The document doesn't seem to be a POM model, project element is missing.");
        if (model.getVersion() != null) {
            model.setVersion(newVersion);
            NodeList children = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!Objects.equal((Object)child.getNodeName(), (Object)NODE_NAME_VERSION)) continue;
                child.setTextContent(newVersion);
            }
        }
    }

    public static void setParentVersion(Model model, Document document, String newParentVersion) {
        Node parentNode;
        Preconditions.checkArgument((boolean)PomUtil.hasChildNode(document, NODE_NAME_PROJECT), (Object)"The document doesn't seem to be a POM model, project element is missing.");
        Parent parent = model.getParent();
        if (parent != null) {
            parent.setVersion(newParentVersion);
        }
        if ((parentNode = document.getDocumentElement().getElementsByTagName(NODE_NAME_PARENT).item(0)) != null) {
            NodeList children = parentNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!Objects.equal((Object)child.getNodeName(), (Object)NODE_NAME_VERSION)) continue;
                child.setTextContent(newParentVersion);
            }
        }
    }

    public static Node getOrCreateBuildNode(Document document, boolean createOnDemand) {
        Preconditions.checkArgument((boolean)PomUtil.hasChildNode(document, NODE_NAME_PROJECT), (Object)"The document doesn't seem to be a POM model, project element is missing.");
        Node build = null;
        Node project = document.getElementsByTagName(NODE_NAME_PROJECT).item(0);
        NodeList children = project.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!Objects.equal((Object)NODE_NAME_BUILD, (Object)node.getNodeName())) continue;
            build = node;
            break;
        }
        if (build == null && createOnDemand) {
            build = document.createElement(NODE_NAME_BUILD);
            project.appendChild(build);
        }
        return build;
    }

    public static Node getOrCreatePluginsNode(Document document, boolean createOnDemand) {
        Preconditions.checkArgument((boolean)PomUtil.hasChildNode(document, NODE_NAME_PROJECT), (Object)"The document doesn't seem to be a POM model, project element is missing.");
        Node build = PomUtil.getOrCreateBuildNode(document, createOnDemand);
        Node plugins = null;
        if (build != null) {
            NodeList children = build.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (!Objects.equal((Object)NODE_NAME_PLUGINS, (Object)node.getNodeName())) continue;
                plugins = node;
                break;
            }
            if (plugins == null && createOnDemand) {
                plugins = document.createElement(NODE_NAME_PLUGINS);
                build.appendChild(plugins);
            }
        }
        return plugins;
    }

    public static Node getPlugin(Document document, String groupId, String artifactId) {
        Preconditions.checkArgument((boolean)PomUtil.hasChildNode(document, NODE_NAME_PROJECT), (Object)"The document doesn't seem to be a POM model, project element is missing.");
        Node pluginsNode = PomUtil.getOrCreatePluginsNode(document, false);
        if (pluginsNode != null) {
            NodeList plugins = pluginsNode.getChildNodes();
            for (int i = 0; i < plugins.getLength(); ++i) {
                Node plugin = plugins.item(i);
                if (!Objects.equal((Object)NODE_NAME_PLUGIN, (Object)plugin.getNodeName())) continue;
                NodeList pluginSettings = plugin.getChildNodes();
                boolean gidMatches = false;
                boolean aidMatches = false;
                for (int j = 0; j < pluginSettings.getLength(); ++j) {
                    Node setting = pluginSettings.item(j);
                    if (Objects.equal((Object)NODE_NAME_GROUP_ID, (Object)setting.getNodeName())) {
                        if (Objects.equal((Object)groupId, (Object)setting.getTextContent())) {
                            gidMatches = true;
                        }
                    } else if (Objects.equal((Object)NODE_NAME_ARTIFACT_ID, (Object)setting.getNodeName()) && Objects.equal((Object)artifactId, (Object)setting.getTextContent())) {
                        aidMatches = true;
                    }
                    if (!gidMatches || !aidMatches) continue;
                    return plugin;
                }
            }
        }
        return null;
    }

    public static Node createPlugin(Document document, String groupId, String artifactId, String version) {
        Preconditions.checkArgument((boolean)PomUtil.hasChildNode(document, NODE_NAME_PROJECT), (Object)"The document doesn't seem to be a POM model, project element is missing.");
        Node plugins = PomUtil.getOrCreatePluginsNode(document, true);
        Node existingPlugin = PomUtil.getPlugin(document, groupId, artifactId);
        if (existingPlugin != null) {
            if (!PomUtil.hasChildNode(existingPlugin, NODE_NAME_VERSION)) {
                Element ver = document.createElement(NODE_NAME_VERSION);
                ver.setTextContent(version);
                existingPlugin.appendChild(ver);
            }
            return existingPlugin;
        }
        Element plugin = document.createElement(NODE_NAME_PLUGIN);
        plugins.appendChild(plugin);
        Element gid = document.createElement(NODE_NAME_GROUP_ID);
        gid.setTextContent(groupId);
        plugin.appendChild(gid);
        Element aid = document.createElement(NODE_NAME_ARTIFACT_ID);
        aid.setTextContent(artifactId);
        plugin.appendChild(aid);
        Element ver = document.createElement(NODE_NAME_VERSION);
        ver.setTextContent(version);
        plugin.appendChild(ver);
        return plugin;
    }

    public static Node createPluginExecution(Node plugin, String id, Optional<String> phase, String ... goals) {
        Document document = plugin.getOwnerDocument();
        Node executions = null;
        NodeList children = plugin.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!Objects.equal((Object)NODE_NAME_EXECUTIONS, (Object)child.getNodeName())) continue;
            executions = child;
            break;
        }
        if (executions == null) {
            executions = document.createElement(NODE_NAME_EXECUTIONS);
            plugin.appendChild(executions);
        }
        Element execution = document.createElement(NODE_NAME_EXECUTION);
        executions.appendChild(execution);
        Element idNode = document.createElement(NODE_NAME_ID);
        idNode.setTextContent(id);
        execution.appendChild(idNode);
        if (phase.isPresent()) {
            Element phaseNode = document.createElement(NODE_NAME_PHASE);
            phaseNode.setTextContent((String)phase.get());
            execution.appendChild(phaseNode);
        }
        if (goals.length > 0) {
            Element goalsNode = document.createElement(NODE_NAME_GOALS);
            execution.appendChild(goalsNode);
            for (String goal : goals) {
                Element goalNode = document.createElement(NODE_NAME_GOAL);
                goalNode.setTextContent(goal);
                goalsNode.appendChild(goalNode);
            }
        }
        return execution;
    }

    public static Node getOrCreateScmNode(Document document, boolean createOnDemand) {
        Preconditions.checkArgument((boolean)PomUtil.hasChildNode(document, NODE_NAME_PROJECT), (Object)"The document doesn't seem to be a POM model, project element is missing.");
        NodeList scmNodeList = document.getElementsByTagName(NODE_NAME_SCM);
        Node scm = null;
        if (scmNodeList.getLength() == 0 && createOnDemand) {
            scm = document.createElement(NODE_NAME_SCM);
            document.getDocumentElement().appendChild(scm);
        } else {
            scm = scmNodeList.item(0);
        }
        return scm;
    }

    public static void setNodeTextContent(Node parentNode, String nodeName, String content, boolean createOnDemand) {
        Node node = null;
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!Objects.equal((Object)nodeName, (Object)n.getNodeName())) continue;
            node = n;
            break;
        }
        if (node == null && createOnDemand) {
            node = parentNode.getOwnerDocument().createElement(nodeName);
            if (children.getLength() > 0) {
                Node lastChild = children.item(children.getLength() - 1);
                Text lineBreak = parentNode.getOwnerDocument().createTextNode("\n");
                parentNode.insertBefore(lineBreak, lastChild);
                parentNode.insertBefore(node, lastChild);
            } else {
                parentNode.appendChild(node);
            }
        }
        if (node != null) {
            node.setTextContent(content);
        }
    }

    public static void deleteNode(Node parentNode, String nodeName) {
        Node nodeToDelete = null;
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!Objects.equal((Object)nodeName, (Object)n.getNodeName())) continue;
            nodeToDelete = n;
            break;
        }
        if (nodeToDelete != null) {
            parentNode.removeChild(nodeToDelete);
        }
    }

    public static boolean hasChildNode(Node parentNode, String nodeName) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!Objects.equal((Object)nodeName, (Object)n.getNodeName())) continue;
            return true;
        }
        return false;
    }
}

