/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.util.functions;

import com.google.common.base.Function;
import org.apache.maven.project.MavenProject;

public enum ProjectToString implements Function<MavenProject, String>
{
    INSTANCE(false, true),
    INCLUDE_PACKAGING(true, true),
    EXCLUDE_VERSION(false, false);

    private boolean includePackaging;
    private boolean includeVersion;

    private ProjectToString(boolean includePackaging, boolean includeVersion) {
        this.includePackaging = includePackaging;
        this.includeVersion = includeVersion;
    }

    public String apply(MavenProject p) {
        StringBuilder sb = new StringBuilder(p.getGroupId());
        sb.append(":").append(p.getArtifactId());
        if (this.includePackaging && p.getPackaging() != null) {
            sb.append(":").append(p.getPackaging());
        }
        if (this.includeVersion && p.getVersion() != null) {
            sb.append(":").append(p.getVersion());
        }
        return sb.toString();
    }
}

