/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.util.scm;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.itemis.maven.plugins.unleash.scm.ScmException;
import com.itemis.maven.plugins.unleash.scm.ScmOperation;
import com.itemis.maven.plugins.unleash.scm.merge.MergeClient;
import com.itemis.maven.plugins.unleash.util.MavenVersionUtil;
import com.itemis.maven.plugins.unleash.util.PomUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.w3c.dom.Document;

public class ScmPomVersionsMergeClient
implements MergeClient {
    public void merge(InputStream local, InputStream remote, InputStream base, OutputStream result) throws ScmException {
        Optional<Model> localModel = this.loadModel(local);
        if (!localModel.isPresent()) {
            throw new ScmException(ScmOperation.MERGE, "Unable to merge non-POM changes.");
        }
        byte[] remoteData = null;
        try {
            remoteData = ByteStreams.toByteArray((InputStream)remote);
        }
        catch (IOException e) {
            throw new ScmException(ScmOperation.MERGE, "Unable to read remote content!", (Throwable)e);
        }
        finally {
            Closeables.closeQuietly((InputStream)remote);
        }
        Optional<Model> remoteModel = this.loadModel(new ByteArrayInputStream(remoteData));
        Optional<Model> baseModel = this.loadModel(base);
        Model resultModel = (Model)this.loadModel(new ByteArrayInputStream(remoteData)).get();
        this.mergeVersions((Model)localModel.get(), (Model)remoteModel.get(), (Model)baseModel.get(), resultModel);
        this.mergeParentVersions((Model)localModel.get(), (Model)remoteModel.get(), (Model)baseModel.get(), resultModel);
        try {
            Document document = PomUtil.parsePOM(new ByteArrayInputStream(remoteData));
            PomUtil.setProjectVersion(resultModel, document, resultModel.getVersion());
            if (resultModel.getParent() != null) {
                PomUtil.setParentVersion(resultModel, document, resultModel.getParent().getVersion());
            }
            PomUtil.writePOM(document, result, false);
        }
        catch (Throwable t) {
            throw new ScmException(ScmOperation.MERGE, "Could not serialize merged POM!", t);
        }
    }

    private void mergeVersions(Model local, Model remote, Model base, Model result) throws ScmException {
        boolean remoteChange;
        boolean bl = remoteChange = !Objects.equal((Object)remote.getVersion(), (Object)base.getVersion());
        if (remoteChange) {
            if (!Objects.equal((Object)local.getVersion(), (Object)remote.getVersion())) {
                if (MavenVersionUtil.isNewerVersion((String)local.getVersion(), (String)remote.getVersion())) {
                    result.setVersion(local.getVersion());
                } else {
                    result.setVersion(remote.getVersion());
                }
            }
        } else {
            result.setVersion(local.getVersion());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mergeParentVersions(Model local, Model remote, Model base, Model result) throws ScmException {
        boolean localParentVersionChanged;
        String localParentVersion = local.getParent() != null ? local.getParent().getVersion() : null;
        String remoteParentVersion = remote.getParent() != null ? remote.getParent().getVersion() : null;
        String baseParentVersion = base.getParent() != null ? base.getParent().getVersion() : null;
        boolean remoteParentRemoved = remoteParentVersion == null && baseParentVersion != null;
        boolean remoteParentAdded = remoteParentVersion != null && baseParentVersion == null;
        boolean remoteParentVersionChanged = !Objects.equal((Object)remoteParentVersion, (Object)baseParentVersion);
        boolean localParentRemoved = localParentVersion == null && baseParentVersion != null;
        boolean localParentAdded = localParentVersion != null && baseParentVersion == null;
        boolean bl = localParentVersionChanged = !Objects.equal((Object)localParentVersion, (Object)baseParentVersion);
        if (localParentAdded) {
            if (remoteParentAdded) {
                if (!Objects.equal((Object)local.getParent().getArtifactId(), (Object)remote.getParent().getArtifactId()) || !Objects.equal((Object)local.getParent().getGroupId(), (Object)remote.getParent().getGroupId())) throw new ScmException(ScmOperation.MERGE, "Could not merge local and remote POM parent changes since both versions added different parent artifacts.");
                if (!MavenVersionUtil.isNewerVersion((String)local.getParent().getVersion(), (String)remote.getParent().getVersion())) return;
                result.setParent(local.getParent());
                return;
            } else {
                result.setParent(local.getParent());
            }
            return;
        } else if (localParentRemoved) {
            if (remoteParentVersionChanged) {
                throw new ScmException(ScmOperation.MERGE, "Could not merge POM parent version conflicts since in the local POM the parent had been removed and in the remote POM the parent had been changed.");
            }
            result.getParent().setVersion(localParentVersion);
            return;
        } else {
            if (!localParentVersionChanged) return;
            if (remoteParentVersionChanged) {
                if (!Objects.equal((Object)local.getParent().getArtifactId(), (Object)remote.getParent().getArtifactId()) || !Objects.equal((Object)local.getParent().getGroupId(), (Object)remote.getParent().getGroupId())) throw new ScmException(ScmOperation.MERGE, "Could not merge local and remote POM parent changes since both versions are referencing different parent artifacts.");
                if (!MavenVersionUtil.isNewerVersion((String)local.getParent().getVersion(), (String)remote.getParent().getVersion())) return;
                result.setParent(local.getParent());
                return;
            } else {
                if (remoteParentRemoved) {
                    throw new ScmException(ScmOperation.MERGE, "Could not merge POM parent version conflicts since in the local POM the parent had been updated while in the remote POM the parent had been removed.");
                }
                result.getParent().setVersion(localParentVersion);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Model> loadModel(InputStream in) {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try {
            Model model = reader.read(in);
            Optional optional = Optional.of((Object)model);
            return optional;
        }
        catch (Exception e) {
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            Closeables.closeQuietly((InputStream)in);
        }
    }
}

