/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.PluginConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginTools {
    private static final Logger logger = LoggerFactory.getLogger(PluginTools.class);

    public static boolean checkDependencyPlugin(Class plugin, Context ctx) {
        return PluginTools.getPluginIndex(plugin, ctx) >= 0;
    }

    public static int getPluginIndex(Class plugin, Context ctx) {
        List<PluginConfiguration> list = PluginTools.getConfigPlugins(ctx);
        for (int i = 0; i < list.size(); ++i) {
            PluginConfiguration config = list.get(i);
            if (!plugin.getName().equals(config.getConfigurationType())) continue;
            return i;
        }
        return -1;
    }

    public static List<PluginConfiguration> getConfigPlugins(Context ctx) {
        try {
            Field field = Context.class.getDeclaredField("pluginConfigurations");
            field.setAccessible(true);
            return (List)field.get(ctx);
        }
        catch (Exception e) {
            logger.error("\u63d2\u4ef6\u68c0\u67e5\u53cd\u5c04\u5f02\u5e38", (Throwable)e);
            return new ArrayList<PluginConfiguration>();
        }
    }
}

