/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonassert;

import com.jayway.jsonassert.JsonAsserter;
import com.jayway.jsonassert.impl.JsonAsserterImpl;
import com.jayway.jsonassert.impl.matcher.CollectionMatcher;
import com.jayway.jsonassert.impl.matcher.IsCollectionWithSize;
import com.jayway.jsonassert.impl.matcher.IsEmptyCollection;
import com.jayway.jsonassert.impl.matcher.IsMapContainingKey;
import com.jayway.jsonassert.impl.matcher.IsMapContainingValue;
import com.jayway.jsonpath.spi.JsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonAssert {
    private static JsonProvider jsonProvider = JsonProvider.getInstance();

    public static void setJsonProvider(JsonProvider jsonProvider) {
        JsonAssert.jsonProvider = jsonProvider;
    }

    public static JsonAsserter with(String json) {
        return new JsonAsserterImpl(jsonProvider.parse(json));
    }

    public static JsonAsserter with(Reader reader) throws IOException {
        return new JsonAsserterImpl(jsonProvider.parse(JsonAssert.convertReaderToString(reader)));
    }

    public static JsonAsserter with(InputStream is) throws IOException {
        InputStreamReader reader = new InputStreamReader(is);
        return JsonAssert.with(reader);
    }

    public static CollectionMatcher collectionWithSize(Matcher<? super Integer> sizeMatcher) {
        return new IsCollectionWithSize(sizeMatcher);
    }

    public static Matcher<Map<String, ?>> mapContainingKey(Matcher<String> keyMatcher) {
        return new IsMapContainingKey<String>(keyMatcher);
    }

    public static <V> Matcher<? super Map<?, V>> mapContainingValue(Matcher<? super V> valueMatcher) {
        return new IsMapContainingValue<V>(valueMatcher);
    }

    public static Matcher<Collection<Object>> emptyCollection() {
        return new IsEmptyCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertReaderToString(Reader reader) throws IOException {
        if (reader != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                reader.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }
}

