/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.module.jsv;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.google.common.collect.Lists;
import com.jayway.restassured.module.jsv.JsonSchemaValidationException;
import com.jayway.restassured.module.jsv.JsonSchemaValidatorSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonSchemaValidator
extends TypeSafeMatcher<String> {
    public static JsonSchemaValidatorSettings settings;
    private final Object schema;
    private final JsonSchemaValidatorSettings instanceSettings;
    private ProcessingReport report;

    private JsonSchemaValidator(Object schema, JsonSchemaValidatorSettings jsonSchemaValidatorSettings) {
        if (jsonSchemaValidatorSettings == null) {
            throw new IllegalArgumentException(JsonSchemaValidatorSettings.class.getSimpleName() + " cannot be null.");
        }
        this.schema = schema;
        this.instanceSettings = jsonSchemaValidatorSettings;
    }

    public static JsonSchemaValidator matchesJsonSchema(String schema) {
        return new JsonSchemaValidatorFactory<String>(){

            JsonNode createSchemaInstance(String input) throws IOException {
                return JsonLoader.fromString((String)input);
            }
        }.create(schema);
    }

    public static JsonSchemaValidator matchesJsonSchemaInClasspath(String pathToSchemaInClasspath) {
        return JsonSchemaValidator.matchesJsonSchema(Thread.currentThread().getContextClassLoader().getResource(pathToSchemaInClasspath));
    }

    public static JsonSchemaValidator matchesJsonSchema(InputStream schema) {
        return JsonSchemaValidator.matchesJsonSchema(new InputStreamReader(schema));
    }

    public static JsonSchemaValidator matchesJsonSchema(Reader schema) {
        return new JsonSchemaValidatorFactory<Reader>(){

            JsonNode createSchemaInstance(Reader input) throws IOException {
                return JsonLoader.fromReader((Reader)input);
            }
        }.create(schema);
    }

    public static JsonSchemaValidator matchesJsonSchema(File file) {
        return new JsonSchemaValidatorFactory<File>(){

            JsonNode createSchemaInstance(File input) throws IOException {
                return JsonLoader.fromFile((File)input);
            }
        }.create(file);
    }

    public static JsonSchemaValidator matchesJsonSchema(URL url) {
        return new JsonSchemaValidatorFactory<URL>(){

            @Override
            Object createSchemaInstance(URL input) throws IOException {
                return input;
            }
        }.create(url);
    }

    public static JsonSchemaValidator matchesJsonSchema(URI uri) {
        return JsonSchemaValidator.matchesJsonSchema(JsonSchemaValidator.toURL(uri));
    }

    public Matcher<?> using(JsonSchemaFactory jsonSchemaFactory) {
        return new JsonSchemaValidator(this.schema, this.instanceSettings.jsonSchemaFactory(jsonSchemaFactory));
    }

    public Matcher<?> using(JsonSchemaValidatorSettings jsonSchemaValidatorSettings) {
        return new JsonSchemaValidator(this.schema, jsonSchemaValidatorSettings);
    }

    private static URL toURL(URI uri) {
        JsonSchemaValidator.validateSchemaIsNotNull(uri);
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Can't convert the supplied URI to a URL", e);
        }
    }

    protected boolean matchesSafely(String content) {
        try {
            JsonSchema jsonSchema;
            JsonNode contentAsJsonNode = JsonLoader.fromString((String)content);
            JsonSchemaFactory jsonSchemaFactory = this.instanceSettings.jsonSchemaFactory();
            Schema loadedSchema = this.loadSchema(this.schema, this.instanceSettings);
            if (loadedSchema.hasType(JsonNode.class)) {
                jsonSchema = jsonSchemaFactory.getJsonSchema((JsonNode)JsonNode.class.cast(loadedSchema.schema));
            } else if (loadedSchema.hasType(String.class)) {
                jsonSchema = jsonSchemaFactory.getJsonSchema((String)String.class.cast(loadedSchema.schema));
            } else {
                throw new RuntimeException("Internal error when loading schema from factory. Type was " + loadedSchema.schema.getClass().getName());
            }
            this.report = this.instanceSettings.shouldUseCheckedValidation() ? jsonSchema.validate(contentAsJsonNode) : jsonSchema.validateUnchecked(contentAsJsonNode);
            return this.report.isSuccess();
        }
        catch (Exception e) {
            throw new JsonSchemaValidationException(e);
        }
    }

    public void describeTo(Description description) {
        if (this.report != null) {
            description.appendText("The content to match the given JSON schema.\n");
            ArrayList messages = Lists.newArrayList((Iterable)this.report);
            if (!messages.isEmpty()) {
                for (ProcessingMessage message : messages) {
                    description.appendText(message.toString());
                }
            }
        }
    }

    private Schema loadSchema(Object input, JsonSchemaValidatorSettings instanceSettings) {
        if (input instanceof JsonNode) {
            return new Schema(input);
        }
        if (input instanceof URL) {
            String loadedSchema;
            if (instanceSettings.shouldParseUriAndUrlsAsJsonNode()) {
                try {
                    loadedSchema = JsonLoader.fromURL((URL)((URL)input));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                loadedSchema = input.toString();
            }
            return new Schema(loadedSchema);
        }
        throw new RuntimeException("Internal error when loading schema: Input was instance of " + input.getClass().getName());
    }

    private static void validateSchemaIsNotNull(Object schema) {
        if (schema == null) {
            throw new IllegalArgumentException("Schema to use cannot be null");
        }
    }

    public static void reset() {
        settings = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Schema {
        private final Object schema;

        private Schema(Object result) {
            this.schema = result;
        }

        public boolean hasType(Class<?> type) {
            return type.isAssignableFrom(this.schema.getClass());
        }

        public <T> T as(Class<T> type) {
            return type.cast(this.schema);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class JsonSchemaValidatorFactory<T> {
        private JsonSchemaValidatorFactory() {
        }

        private JsonSchemaValidatorSettings createSettings() {
            return settings == null ? new JsonSchemaValidatorSettings() : settings;
        }

        public JsonSchemaValidator create(T schema) {
            Object loadedSchema;
            JsonSchemaValidator.validateSchemaIsNotNull(schema);
            try {
                loadedSchema = this.createSchemaInstance(schema);
            }
            catch (IOException e) {
                throw new JsonSchemaValidationException(e);
            }
            return new JsonSchemaValidator(loadedSchema, this.createSettings());
        }

        abstract Object createSchemaInstance(T var1) throws IOException;
    }
}

