/*
 * Decompiled with CFR 0.152.
 */
package com.julienviet.childprocess;

import com.julienviet.childprocess.ProcessOptions;
import com.julienviet.childprocess.StreamInput;
import com.julienviet.childprocess.StreamOutput;
import com.julienviet.childprocess.impl.ProcessImpl;
import com.zaxxer.nuprocess.NuProcessBuilder;
import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@VertxGen
public interface Process {
    public static Map<String, String> env() {
        return new HashMap<String, String>(System.getenv());
    }

    public static Process spawn(Vertx vertx, String command) {
        return Process.spawn(vertx, command, Collections.emptyList(), new ProcessOptions());
    }

    public static Process spawn(Vertx vertx, String command, List<String> args) {
        return Process.spawn(vertx, command, args, new ProcessOptions());
    }

    public static Process spawn(Vertx vertx, String command, ProcessOptions options) {
        return Process.spawn(vertx, command, Collections.emptyList(), new ProcessOptions());
    }

    public static Process spawn(Vertx vertx, String command, List<String> args, ProcessOptions options) {
        Process process = Process.create(vertx, command, args, options);
        process.start();
        return process;
    }

    public static Process create(Vertx vertx, String command) {
        return Process.create(vertx, command, Collections.emptyList(), new ProcessOptions());
    }

    public static Process create(Vertx vertx, String command, List<String> args) {
        return Process.create(vertx, command, args, new ProcessOptions());
    }

    public static Process create(Vertx vertx, String command, ProcessOptions options) {
        return Process.create(vertx, command, Collections.emptyList(), new ProcessOptions());
    }

    public static Process create(Vertx vertx, String command, List<String> args, ProcessOptions options) {
        HashMap env = new HashMap();
        if (options.getEnv() != null) {
            options.getEnv().entrySet().forEach(entry -> {
                if (entry.getValue() != null) {
                    env.put(entry.getKey(), entry.getValue());
                }
            });
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(command);
        commands.addAll(args);
        NuProcessBuilder builder = new NuProcessBuilder(commands, env);
        if (options.getCwd() != null) {
            builder.setCwd(new File(options.getCwd()).toPath());
        }
        return new ProcessImpl(vertx.getOrCreateContext(), builder);
    }

    public void start();

    public void start(Handler<Process> var1);

    @Fluent
    public Process exitHandler(Handler<Integer> var1);

    public Integer pid();

    @CacheReturn
    public StreamOutput stdin();

    @CacheReturn
    public StreamInput stdout();

    @CacheReturn
    public StreamInput stderr();

    default public void kill() {
        this.kill(false);
    }

    public void kill(boolean var1);

    public boolean isRunning();
}

