/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.configuration.cdi.interceptors;

import com.kumuluz.ee.common.utils.StringUtils;
import com.kumuluz.ee.configuration.cdi.ConfigBundle;
import com.kumuluz.ee.configuration.cdi.ConfigValue;
import com.kumuluz.ee.configuration.utils.ConfigurationUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@ConfigBundle
@Priority(value=1000)
public class ConfigBundleInterceptor {
    private static final Logger log = Logger.getLogger(ConfigBundleInterceptor.class.getName());
    private static final ConfigurationUtil configurationUtil = ConfigurationUtil.getInstance();
    private final Class[] primitives = new Class[]{String.class, Boolean.class, Float.class, Double.class, Integer.class, Long.class, Boolean.TYPE, Float.TYPE, Double.TYPE, Integer.TYPE, Long.TYPE};

    @PostConstruct
    public Object loadConfiguration(InvocationContext ic) throws Exception {
        Object target = ic.getTarget();
        Class<?> targetClass = target.getClass();
        if (this.targetClassIsProxied(targetClass)) {
            targetClass = targetClass.getSuperclass();
        }
        ConfigBundle configBundleAnnotation = targetClass.getDeclaredAnnotation(ConfigBundle.class);
        this.processConfigBundleBeanSetters(target, targetClass, this.getKeyPrefix(targetClass), new HashMap<Class, Class>(), configBundleAnnotation.watch());
        return ic.proceed();
    }

    private boolean processConfigBundleBeanSetters(Object target, Class targetClass, String keyPrefix, Map<Class, Class> processedClassRelations, boolean watchAllFields) throws Exception {
        boolean isConfigBundleEmpty = true;
        for (Method method : targetClass.getMethods()) {
            int i;
            boolean watchNestedClass;
            if (!method.getName().substring(0, 3).equals("set") || method.getParameters().length != 1) continue;
            Class<?> parameterType = method.getParameters()[0].getType();
            Field field = targetClass.getDeclaredField(this.setterToField(method.getName()));
            ConfigValue fieldAnnotation = null;
            if (field != null) {
                fieldAnnotation = field.getAnnotation(ConfigValue.class);
            }
            if (!(watchNestedClass = watchAllFields) && fieldAnnotation != null) {
                watchNestedClass = fieldAnnotation.watch();
            }
            if (Arrays.asList(this.primitives).contains(parameterType)) {
                Optional value = this.getValueOfPrimitive(parameterType, this.getKeyName(targetClass, method.getName(), keyPrefix));
                if (value.isPresent()) {
                    isConfigBundleEmpty = false;
                    method.invoke(target, value.get());
                }
                if (!watchAllFields && (fieldAnnotation == null || !fieldAnnotation.watch())) continue;
                this.deployWatcher(target, method, this.getKeyName(targetClass, method.getName(), keyPrefix));
                continue;
            }
            if (!parameterType.isArray()) {
                processedClassRelations.put(targetClass, parameterType);
                Object nestedTarget = this.processNestedObject(targetClass, method, parameterType, keyPrefix, processedClassRelations, -1, watchNestedClass);
                if (nestedTarget == null) continue;
                method.invoke(target, nestedTarget);
                continue;
            }
            Class<?> componentType = parameterType.getComponentType();
            Object array = Array.newInstance(componentType, (int)configurationUtil.getListSize(this.getKeyName(targetClass, method.getName(), keyPrefix)).orElse(0));
            if (Arrays.asList(this.primitives).contains(componentType)) {
                for (i = 0; i < Array.getLength(array); ++i) {
                    Optional valueOfPrimitive = this.getValueOfPrimitive(componentType, this.getKeyName(targetClass, method.getName(), keyPrefix) + "[" + i + "]");
                    if (!valueOfPrimitive.isPresent()) continue;
                    Array.set(array, i, valueOfPrimitive.get());
                }
            } else {
                for (i = 0; i < Array.getLength(array); ++i) {
                    Object nestedTarget = this.processNestedObject(targetClass, method, componentType, keyPrefix, processedClassRelations, i, watchNestedClass);
                    if (nestedTarget == null) continue;
                    Array.set(array, i, nestedTarget);
                }
            }
            method.invoke(target, array);
        }
        return isConfigBundleEmpty;
    }

    private Optional getValueOfPrimitive(Class type, String key) {
        if (type.equals(String.class)) {
            return configurationUtil.get(key);
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return configurationUtil.getBoolean(key);
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return configurationUtil.getFloat(key);
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return configurationUtil.getDouble(key);
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return configurationUtil.getInteger(key);
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return configurationUtil.getLong(key);
        }
        return Optional.empty();
    }

    private Object processNestedObject(Class targetClass, Method method, Class parameterType, String keyPrefix, Map<Class, Class> processedClassRelations, int arrayIndex, boolean watchAllFields) throws Exception {
        Object nestedTarget = parameterType.getConstructor(new Class[0]).newInstance(new Object[0]);
        Class<?> nestedTargetClass = nestedTarget.getClass();
        if (processedClassRelations.containsKey(nestedTargetClass) && processedClassRelations.get(nestedTargetClass).equals(targetClass)) {
            log.warning("There is a cycle in the configuration class tree. ConfigBundle class may not be populated as expected.");
        } else {
            boolean isEmpty;
            String key = this.getKeyName(targetClass, method.getName(), keyPrefix);
            if (arrayIndex >= 0) {
                key = key + "[" + arrayIndex + "]";
            }
            if (isEmpty = this.processConfigBundleBeanSetters(nestedTarget, nestedTargetClass, key, processedClassRelations, watchAllFields)) {
                return null;
            }
        }
        return nestedTarget;
    }

    private String getKeyName(Class targetClass, String setter, String keyPrefix) throws Exception {
        StringBuilder key = new StringBuilder();
        key.append(keyPrefix);
        if (!key.toString().isEmpty()) {
            key.append(".");
        }
        Field field = targetClass.getDeclaredField(this.setterToField(setter));
        ConfigValue fieldAnnotation = null;
        if (field != null) {
            fieldAnnotation = field.getAnnotation(ConfigValue.class);
        }
        if (fieldAnnotation != null && !fieldAnnotation.value().isEmpty()) {
            key.append(StringUtils.camelCaseToHyphenCase((String)fieldAnnotation.value()));
        } else {
            key.append(StringUtils.camelCaseToHyphenCase((String)setter.substring(3)));
        }
        return key.toString();
    }

    private String getKeyPrefix(Class targetClass) {
        String prefix = targetClass.getAnnotation(ConfigBundle.class).value();
        if (prefix.isEmpty()) {
            prefix = StringUtils.camelCaseToHyphenCase((String)targetClass.getSimpleName());
        }
        if (".".equals(prefix)) {
            prefix = "";
        }
        return prefix;
    }

    private String setterToField(String setter) {
        return Character.toLowerCase(setter.charAt(3)) + setter.substring(4);
    }

    private boolean targetClassIsProxied(Class targetClass) {
        return targetClass.getCanonicalName().contains("$Proxy");
    }

    private void deployWatcher(Object target, Method method, String watchedKey) throws Exception {
        configurationUtil.subscribe(watchedKey, (key, value) -> {
            if (Objects.equals(watchedKey, key)) {
                try {
                    if (String.class.equals(method.getParameters()[0].getType())) {
                        method.invoke(target, value);
                    } else if (Boolean.class.equals(method.getParameters()[0].getType()) || Boolean.TYPE.equals(method.getParameters()[0].getType())) {
                        method.invoke(target, Boolean.parseBoolean(value));
                    } else if (Float.class.equals(method.getParameters()[0].getType()) || Float.TYPE.equals(method.getParameters()[0].getType())) {
                        try {
                            method.invoke(target, Float.valueOf(Float.parseFloat(value)));
                        }
                        catch (NumberFormatException e) {
                            log.severe("Exception while storing new value: Number format exception. Expected: Float. Value: " + value);
                        }
                    } else if (Double.class.equals(method.getParameters()[0].getType()) || Double.TYPE.equals(method.getParameters()[0].getType())) {
                        try {
                            method.invoke(target, Double.parseDouble(value));
                        }
                        catch (NumberFormatException e) {
                            log.severe("Exception while storing new value: Number format exception. Expected: Double. Value: " + value);
                        }
                    } else if (Integer.class.equals(method.getParameters()[0].getType()) || Integer.TYPE.equals(method.getParameters()[0].getType())) {
                        try {
                            method.invoke(target, Integer.parseInt(value));
                        }
                        catch (NumberFormatException e) {
                            log.severe("Exception while storing new value: Number format exception. Expected: Integer. Value: " + value);
                        }
                    } else if (Long.class.equals(method.getParameters()[0].getType()) || Long.TYPE.equals(method.getParameters()[0].getType())) {
                        try {
                            method.invoke(target, Long.parseLong(value));
                        }
                        catch (NumberFormatException e) {
                            log.severe("Exception while storing new value: Number format exception. Expected: Long. Value: " + value);
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    log.severe("Illegal access exception: " + e.toString());
                }
                catch (InvocationTargetException e) {
                    log.severe("Invocation target exception: " + e.toString());
                }
            }
        });
    }
}

