/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.jta.common;

import com.kumuluz.ee.jta.common.TransactionAcquirer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;

public class JtaTransactionHolder {
    public static final List<Integer> TRANSACTION_ACTIVE_STATUS = Arrays.asList(0, 8, 1, 2, 7, 9);
    private static final JtaTransactionHolder INSTANCE = new JtaTransactionHolder();
    private TransactionAcquirer transactionAcquirer;

    private JtaTransactionHolder() {
    }

    public static JtaTransactionHolder getInstance() {
        return INSTANCE;
    }

    public void setTransactionAcquirer(TransactionAcquirer transactionAcquirer) {
        this.transactionAcquirer = transactionAcquirer;
    }

    private void validateTransactionAcquirer() {
        Objects.requireNonNull(this.transactionAcquirer, "TransactionAcquirer not found!");
    }

    public TransactionManager getTransactionManager() {
        this.validateTransactionAcquirer();
        return this.transactionAcquirer.getTransactionManager();
    }

    public UserTransaction getUserTransaction() {
        this.validateTransactionAcquirer();
        return this.transactionAcquirer.getUserTransaction();
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        this.validateTransactionAcquirer();
        return this.transactionAcquirer.getTransactionSynchronizationRegistry();
    }
}

