/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.jta.common.datasources;

import com.kumuluz.ee.jta.common.datasources.JtaXAConnectionWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class XAStatementProxy
implements InvocationHandler {
    private Statement statement;
    private JtaXAConnectionWrapper jtaXaConnectionWrapper;

    private XAStatementProxy(Statement statement, JtaXAConnectionWrapper jtaXaConnectionWrapper) {
        this.statement = statement;
        this.jtaXaConnectionWrapper = jtaXaConnectionWrapper;
    }

    public static Object newInstance(Statement statement, JtaXAConnectionWrapper jtaXaConnectionWrapper) {
        return Proxy.newProxyInstance(statement.getClass().getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new XAStatementProxy(statement, jtaXaConnectionWrapper));
    }

    public static Object newInstance(PreparedStatement statement, JtaXAConnectionWrapper jtaXaConnectionWrapper) {
        return Proxy.newProxyInstance(statement.getClass().getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new XAStatementProxy(statement, jtaXaConnectionWrapper));
    }

    public static Object newInstance(CallableStatement statement, JtaXAConnectionWrapper jtaXaConnectionWrapper) {
        return Proxy.newProxyInstance(statement.getClass().getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)new XAStatementProxy(statement, jtaXaConnectionWrapper));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.jtaXaConnectionWrapper.isClosed()) {
            throw new SQLException("The connection associated with this statement is closed");
        }
        return method.invoke((Object)this.statement, args);
    }
}

