/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.jetty;

import com.kumuluz.ee.common.config.ServerConfig;
import com.kumuluz.ee.common.config.ServerConnectorConfig;
import com.kumuluz.ee.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.log.JavaUtilLog;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class JettyFactory {
    private Logger log = Logger.getLogger(JettyFactory.class.getSimpleName());
    private ServerConfig serverConfig;

    public JettyFactory(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public Server create() {
        Log.setLog((org.eclipse.jetty.util.log.Logger)new JavaUtilLog());
        Server server = new Server(this.createThreadPool());
        server.addBean((Object)this.createClassList());
        server.setStopAtShutdown(true);
        server.setConnectors(this.createConnectors(server));
        return server;
    }

    private ThreadPool createThreadPool() {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(this.serverConfig.getMinThreads().intValue());
        threadPool.setMaxThreads(this.serverConfig.getMaxThreads().intValue());
        this.log.info("Starting KumuluzEE on Jetty with " + this.serverConfig.getMinThreads() + " minimum and " + this.serverConfig.getMaxThreads() + " maximum threads");
        return threadPool;
    }

    private Connector[] createConnectors(Server server) {
        HttpConnectionFactory http;
        ServerConnectorConfig httpConfig = this.serverConfig.getHttp();
        ServerConnectorConfig httpsConfig = this.serverConfig.getHttps();
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        if (Boolean.FALSE.equals(httpConfig.getEnabled()) && (httpsConfig == null || Boolean.FALSE.equals(httpsConfig.getEnabled()))) {
            throw new IllegalStateException("Both the HTTP and HTTPS connectors can not be disabled. Please enable at least one.");
        }
        if (this.serverConfig.getForceHttps().booleanValue() && (httpsConfig == null || !Boolean.TRUE.equals(httpsConfig.getEnabled()))) {
            throw new IllegalStateException("You must enable the HTTPS connector in order to force redirects to it (`kumuluzee.server.https.enabled` must be true).");
        }
        if (httpConfig.getEnabled() == null || httpConfig.getEnabled().booleanValue()) {
            ServerConnector httpConnector;
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            httpConfiguration.setRequestHeaderSize(httpConfig.getRequestHeaderSize().intValue());
            httpConfiguration.setResponseHeaderSize(httpConfig.getResponseHeaderSize().intValue());
            httpConfiguration.setSendServerVersion(this.serverConfig.getShowServerInfo().booleanValue());
            if (Boolean.TRUE.equals(httpConfig.getProxyForwarding())) {
                httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
            }
            if (httpsConfig != null && Boolean.TRUE.equals(httpsConfig.getEnabled())) {
                httpConfiguration.setSecurePort((httpsConfig.getPort() == null ? ServerConnectorConfig.DEFAULT_HTTPS_PORT : httpsConfig.getPort()).intValue());
            }
            http = new HttpConnectionFactory(httpConfiguration);
            if (httpConfig.getHttp2().booleanValue()) {
                HTTP2CServerConnectionFactory http2c = new HTTP2CServerConnectionFactory(httpConfiguration);
                httpConnector = new ServerConnector(server, new ConnectionFactory[]{http, http2c});
            } else {
                httpConnector = new ServerConnector(server, new ConnectionFactory[]{http});
            }
            httpConnector.setPort((httpConfig.getPort() == null ? ServerConnectorConfig.DEFAULT_HTTP_PORT : httpConfig.getPort()).intValue());
            httpConnector.setHost(httpConfig.getAddress());
            httpConnector.setIdleTimeout((long)httpConfig.getIdleTimeout().intValue());
            connectors.add(httpConnector);
        }
        if (httpsConfig != null && httpsConfig.getEnabled() != null && httpsConfig.getEnabled().booleanValue()) {
            ServerConnector httpsConnector;
            if (StringUtils.isNullOrEmpty((String)httpsConfig.getKeystorePath())) {
                throw new IllegalStateException("Cannot create SSL connector; keystore path not specified.");
            }
            if (StringUtils.isNullOrEmpty((String)httpsConfig.getKeystorePassword())) {
                throw new IllegalStateException("Cannot create SSL connector; keystore password not specified.");
            }
            if (StringUtils.isNullOrEmpty((String)httpsConfig.getKeyPassword())) {
                throw new IllegalStateException("Cannot create SSL connector; key password not specified.");
            }
            HttpConfiguration httpsConfiguration = new HttpConfiguration();
            httpsConfiguration.setRequestHeaderSize(httpsConfig.getRequestHeaderSize().intValue());
            httpsConfiguration.setResponseHeaderSize(httpsConfig.getResponseHeaderSize().intValue());
            httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            httpsConfiguration.setSendServerVersion(this.serverConfig.getShowServerInfo().booleanValue());
            if (Boolean.TRUE.equals(httpsConfig.getProxyForwarding())) {
                httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
            }
            http = new HttpConnectionFactory(httpsConfiguration);
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(httpsConfig.getKeystorePath());
            sslContextFactory.setKeyStorePassword(httpsConfig.getKeystorePassword());
            if (httpsConfig.getKeyPassword() != null) {
                sslContextFactory.setKeyManagerPassword(httpsConfig.getKeyPassword());
            }
            if (StringUtils.isNullOrEmpty((String)httpsConfig.getKeyAlias())) {
                sslContextFactory.setCertAlias(httpsConfig.getKeyAlias());
            }
            if (httpsConfig.getSslProtocols() != null) {
                sslContextFactory.setIncludeProtocols(httpsConfig.getSslProtocols().toArray(new String[0]));
            }
            if (httpsConfig.getSslCiphers() != null) {
                sslContextFactory.setExcludeCipherSuites(new String[0]);
                sslContextFactory.setIncludeCipherSuites(httpsConfig.getSslCiphers().toArray(new String[0]));
            }
            if (httpsConfig.getHttp2().booleanValue()) {
                sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
                sslContextFactory.setUseCipherSuitesOrder(true);
                HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(httpsConfiguration);
                ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
                alpn.setDefaultProtocol(HttpVersion.HTTP_1_1.toString());
                SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, alpn.getProtocol());
                httpsConnector = new ServerConnector(server, new ConnectionFactory[]{ssl, alpn, h2, http});
            } else {
                SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, http.getProtocol());
                httpsConnector = new ServerConnector(server, new ConnectionFactory[]{ssl, http});
            }
            httpsConnector.setPort((httpsConfig.getPort() == null ? ServerConnectorConfig.DEFAULT_HTTPS_PORT : httpsConfig.getPort()).intValue());
            httpsConnector.setHost(httpsConfig.getAddress());
            httpsConnector.setIdleTimeout((long)httpsConfig.getIdleTimeout().intValue());
            connectors.add(httpsConnector);
        }
        String ports = connectors.stream().map(connector -> String.format("%d [%s]", connector.getPort(), String.join((CharSequence)", ", connector.getProtocols()))).collect(Collectors.joining(", "));
        this.log.info(String.format("Starting KumuluzEE on port(s): %s", ports));
        return (Connector[])connectors.toArray(new ServerConnector[connectors.size()]);
    }

    private Configuration.ClassList createClassList() {
        Configuration.ClassList classList = new Configuration.ClassList(new String[0]);
        classList.add((Object)AnnotationConfiguration.class.getName());
        classList.add((Object)WebInfConfiguration.class.getName());
        classList.add((Object)WebXmlConfiguration.class.getName());
        classList.add((Object)MetaInfConfiguration.class.getName());
        classList.add((Object)FragmentConfiguration.class.getName());
        classList.add((Object)JettyWebXmlConfiguration.class.getName());
        classList.add((Object)EnvConfiguration.class.getName());
        classList.add((Object)PlusConfiguration.class.getName());
        return classList;
    }
}

