/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.jetty;

import com.kumuluz.ee.common.ServletServer;
import com.kumuluz.ee.common.config.EeConfig;
import com.kumuluz.ee.common.config.ServerConfig;
import com.kumuluz.ee.common.dependencies.EeComponentType;
import com.kumuluz.ee.common.dependencies.ServerDef;
import com.kumuluz.ee.common.exceptions.KumuluzServerException;
import com.kumuluz.ee.common.servlet.ServletWrapper;
import com.kumuluz.ee.common.utils.ResourceUtils;
import com.kumuluz.ee.jetty.JettyFactory;
import com.kumuluz.ee.jetty.JettyJarClasspathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import org.eclipse.jetty.plus.jndi.Resource;
import org.eclipse.jetty.plus.jndi.Transaction;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;

@ServerDef(value="Jetty", provides={EeComponentType.SERVLET})
public class JettyServletServer
implements ServletServer {
    private Logger log = Logger.getLogger(JettyServletServer.class.getSimpleName());
    private Server server;
    private WebAppContext appContext;
    private ServerConfig serverConfig;

    public void initServer() {
        this.server = this.createJettyFactory().create();
    }

    public void startServer() {
        if (this.server == null) {
            throw new IllegalStateException("Jetty has to be initialized before starting it");
        }
        if (this.server.isStarted() || this.server.isStarting()) {
            throw new IllegalStateException("Jetty is already started");
        }
        try {
            this.server.start();
        }
        catch (Exception e) {
            this.log.severe(e.getMessage());
            throw new KumuluzServerException(e.getMessage(), (Throwable)e);
        }
    }

    public void stopServer() {
        if (this.server == null) {
            throw new IllegalStateException("Jetty has to be initialized before stopping it");
        }
        if (this.server.isStopped() || this.server.isStopping()) {
            throw new IllegalStateException("Jetty is already stopped");
        }
        try {
            this.server.stop();
        }
        catch (Exception e) {
            this.log.severe(e.getMessage());
            throw new KumuluzServerException(e.getMessage(), e.getCause());
        }
    }

    public void initWebContext(List<String> scanLibraries) {
        if (this.server == null) {
            throw new IllegalStateException("Jetty has to be initialized before adding a web context");
        }
        if (this.server.isStarted() || this.server.isStarting()) {
            throw new IllegalStateException("Jetty cannot be started before adding a web context");
        }
        if (EeConfig.getInstance().getDev().getScanLibraries() != null) {
            scanLibraries.addAll(EeConfig.getInstance().getDev().getScanLibraries());
        }
        this.appContext = new WebAppContext();
        if (ResourceUtils.isRunningInJar()) {
            this.appContext.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)"^((?!lib\\_[^\\/]*\\.jar\\.[^\\/]*\\.tmp|/lib\\_[^\\/]*\\.jar\\.[^\\/]*\\.tmp|.*\\/jre\\/lib\\/.*).)*$");
            this.appContext.setExtraClasspath(JettyJarClasspathUtil.getExtraClasspath(scanLibraries));
            try {
                this.appContext.setClassLoader(this.getClass().getClassLoader());
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to set custom classloader for Jetty", e);
            }
        } else {
            StringBuilder explodedClasspath = new StringBuilder("^.*/classes/.*$");
            for (String lib : scanLibraries) {
                if (lib.endsWith(".jar")) {
                    explodedClasspath.append("|^.*/").append(Pattern.quote(lib)).append("$");
                    continue;
                }
                explodedClasspath.append("|^.*/").append(Pattern.quote(lib)).append("-[^/]+\\.jar$");
            }
            this.log.fine("Using classpath scanning regex: " + explodedClasspath.toString());
            this.appContext.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)explodedClasspath.toString());
        }
        this.appContext.setParentLoaderPriority(true);
        this.appContext.setResourceBase(ResourceUtils.getProjectWebResources());
        this.appContext.setContextPath(this.serverConfig.getContextPath());
        if (this.serverConfig.getForwardStartupException() != null) {
            this.appContext.setThrowUnavailableOnStartupException(this.serverConfig.getForwardStartupException().booleanValue());
        }
        if (!Boolean.TRUE.equals(this.serverConfig.getDirBrowsing())) {
            this.appContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        }
        this.log.info("Starting KumuluzEE with context root '" + this.serverConfig.getContextPath() + "'");
        if (this.serverConfig.getForceHttps().booleanValue()) {
            HandlerList handlers = new HandlerList();
            handlers.setHandlers(new Handler[]{new SecuredRedirectHandler(), this.appContext});
            this.server.setHandler((Handler)handlers);
        } else {
            this.server.setHandler((Handler)this.appContext);
        }
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void registerServlet(Class<? extends Servlet> servletClass, String mapping) {
        this.registerServlet(servletClass, mapping, null, 0);
    }

    public void registerServlet(Class<? extends Servlet> servletClass, String mapping, Map<String, String> parameters) {
        this.registerServlet(servletClass, mapping, parameters, 0);
    }

    public void registerServlet(Class<? extends Servlet> servletClass, String mapping, Map<String, String> parameters, int initOrder) {
        if (this.server == null) {
            throw new IllegalStateException("Jetty has to be initialized before adding a servlet ");
        }
        if (this.server.isStarted() || this.server.isStarting()) {
            throw new IllegalStateException("Jetty cannot be started before adding a servlet");
        }
        Class<? extends Servlet> servlet = servletClass;
        ServletHolder holder = new ServletHolder(servlet);
        holder.setInitOrder(initOrder);
        if (parameters != null) {
            parameters.forEach((arg_0, arg_1) -> ((ServletHolder)holder).setInitParameter(arg_0, arg_1));
        }
        this.appContext.addServlet(holder, mapping);
    }

    public void registerListener(EventListener listener) {
        if (this.server == null) {
            throw new IllegalStateException("Jetty has to be initialized before adding a listener");
        }
        if (this.server.isStarted() || this.server.isStarting()) {
            throw new IllegalStateException("Jetty cannot be started before adding a listener");
        }
        this.appContext.addEventListener(listener);
    }

    public void registerFilter(Class<? extends Filter> filterClass, String pathSpec) {
        this.registerFilter(filterClass, pathSpec, EnumSet.of(DispatcherType.REQUEST));
    }

    public void registerFilter(Class<? extends Filter> filterClass, String pathSpec, Map<String, String> parameters) {
        this.registerFilter(filterClass, pathSpec, EnumSet.of(DispatcherType.REQUEST), parameters);
    }

    public void registerFilter(Class<? extends Filter> filterClass, String pathSpec, EnumSet<DispatcherType> dispatches) {
        this.registerFilter(filterClass, pathSpec, dispatches, null);
    }

    public void registerFilter(Class<? extends Filter> filterClass, String pathSpec, EnumSet<DispatcherType> dispatches, Map<String, String> parameters) {
        if (this.server == null) {
            throw new IllegalStateException("Jetty has to be initialized before adding a servlet ");
        }
        if (this.server.isStarted() || this.server.isStarting()) {
            throw new IllegalStateException("Jetty cannot be started before adding a servlet");
        }
        FilterHolder holder = new FilterHolder(filterClass);
        if (parameters != null) {
            parameters.forEach((arg_0, arg_1) -> ((FilterHolder)holder).setInitParameter(arg_0, arg_1));
        }
        this.appContext.addFilter(holder, pathSpec, dispatches);
    }

    public void registerDataSource(DataSource ds, String jndiName) {
        try {
            Resource resource = new Resource(jndiName, (Object)ds);
            this.appContext.setAttribute(jndiName, (Object)resource);
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("Unable to create naming data source entry with jndi name " + jndiName + "", e);
        }
    }

    public List<ServletWrapper> getRegisteredServlets() {
        ArrayList<ServletWrapper> servlets = new ArrayList<ServletWrapper>();
        Arrays.stream(this.appContext.getServletHandler().getServlets()).forEach(s -> servlets.add(new ServletWrapper(s.getName(), s.getContextPath())));
        return servlets;
    }

    public void registerResource(Object o, String jndiName) {
        try {
            Resource resource = new Resource(jndiName, o);
            this.appContext.setAttribute(jndiName, (Object)resource);
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("Unable to create naming resource entry with jndi name " + jndiName + "", e);
        }
    }

    public void registerTransactionManager(UserTransaction userTransaction) {
        try {
            new Transaction(userTransaction);
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("Unable to create transaction manager", e);
        }
    }

    private JettyFactory createJettyFactory() {
        return new JettyFactory(this.serverConfig);
    }
}

