/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc.protocol;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaStatusException;
import com.linecorp.armeria.common.grpc.protocol.Decompressor;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCounted;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import javax.annotation.Nullable;

public class ArmeriaMessageDeframer
implements AutoCloseable {
    private static final String DEBUG_STRING = ArmeriaMessageDeframer.class.getName();
    private static final int HEADER_LENGTH = 5;
    private static final int COMPRESSED_FLAG_MASK = 1;
    private static final int RESERVED_MASK = 126;
    private static final int UNINITIALIED_TYPE = -1;
    private final Listener listener;
    private final int maxMessageSizeBytes;
    private final ByteBufAllocator alloc;
    private int currentType = -1;
    private int requiredLength = 5;
    @Nullable
    private Decompressor decompressor;
    private boolean endOfStream;
    private boolean closeWhenComplete;
    @Nullable
    private Queue<ByteBuf> unprocessed;
    private int unprocessedBytes;
    private long pendingDeliveries;
    private boolean inDelivery;
    private boolean startedDeframing;

    public ArmeriaMessageDeframer(Listener listener, int maxMessageSizeBytes, ByteBufAllocator alloc) {
        this.listener = Objects.requireNonNull(listener, "listener");
        this.maxMessageSizeBytes = maxMessageSizeBytes > 0 ? maxMessageSizeBytes : Integer.MAX_VALUE;
        this.alloc = Objects.requireNonNull(alloc, "alloc");
        this.unprocessed = new ArrayDeque<ByteBuf>();
    }

    public void request(int numMessages) {
        Preconditions.checkArgument((numMessages > 0 ? 1 : 0) != 0, (Object)"numMessages must be > 0");
        if (this.isClosed()) {
            return;
        }
        this.pendingDeliveries += (long)numMessages;
        this.deliver();
    }

    public boolean isStalled() {
        return !this.hasRequiredBytes();
    }

    public void deframe(HttpData data, boolean endOfStream) {
        Objects.requireNonNull(data, "data");
        this.checkNotClosed();
        Preconditions.checkState((!this.endOfStream ? 1 : 0) != 0, (Object)"Past end of stream");
        this.startedDeframing = true;
        int dataLength = data.length();
        if (dataLength != 0) {
            ByteBuf buf = data instanceof ByteBufHolder ? ((ByteBufHolder)data).content() : Unpooled.wrappedBuffer((byte[])data.array());
            assert (this.unprocessed != null);
            this.unprocessed.add(buf);
            this.unprocessedBytes += dataLength;
        }
        this.endOfStream = endOfStream;
        this.deliver();
    }

    public void closeWhenComplete() {
        if (this.isClosed()) {
            return;
        }
        if (this.isStalled()) {
            this.close();
        } else {
            this.closeWhenComplete = true;
        }
    }

    @Override
    public void close() {
        if (this.unprocessed != null) {
            try {
                this.unprocessed.forEach(ReferenceCounted::release);
            }
            finally {
                this.unprocessed = null;
            }
            if (this.endOfStream) {
                this.listener.endOfStream();
            }
        }
    }

    public boolean isClosed() {
        return this.unprocessed == null;
    }

    public ArmeriaMessageDeframer decompressor(@Nullable Decompressor decompressor) {
        Preconditions.checkState((!this.startedDeframing ? 1 : 0) != 0, (Object)"Deframing has already started, cannot change decompressor mid-stream.");
        this.decompressor = decompressor;
        return this;
    }

    private void checkNotClosed() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"MessageDeframer is already closed");
    }

    private void deliver() {
        if (this.inDelivery) {
            return;
        }
        this.inDelivery = true;
        try {
            while (this.pendingDeliveries > 0L && this.hasRequiredBytes()) {
                if (this.currentType == -1) {
                    this.readHeader();
                    continue;
                }
                this.readBody();
                --this.pendingDeliveries;
            }
            if (this.closeWhenComplete && this.isStalled()) {
                this.close();
            }
        }
        finally {
            this.inDelivery = false;
        }
    }

    private boolean hasRequiredBytes() {
        return this.unprocessedBytes >= this.requiredLength;
    }

    private void readHeader() {
        int type = this.readUnsignedByte();
        if ((type & 0x7E) != 0) {
            throw new ArmeriaStatusException(13, DEBUG_STRING + ": Frame header malformed: reserved bits not zero");
        }
        this.requiredLength = this.readInt();
        if (this.requiredLength < 0 || this.requiredLength > this.maxMessageSizeBytes) {
            throw new ArmeriaStatusException(8, String.format("%s: Frame size %d exceeds maximum: %d. ", DEBUG_STRING, this.requiredLength, this.maxMessageSizeBytes));
        }
        this.currentType = type;
    }

    private int readUnsignedByte() {
        --this.unprocessedBytes;
        assert (this.unprocessed != null);
        ByteBuf firstBuf = this.unprocessed.peek();
        assert (firstBuf != null);
        short value = firstBuf.readUnsignedByte();
        if (!firstBuf.isReadable()) {
            this.unprocessed.remove().release();
        }
        return value;
    }

    private int readInt() {
        this.unprocessedBytes -= 4;
        assert (this.unprocessed != null);
        ByteBuf firstBuf = this.unprocessed.peek();
        assert (firstBuf != null);
        int firstBufLen = firstBuf.readableBytes();
        if (firstBufLen >= 4) {
            int value = firstBuf.readInt();
            if (!firstBuf.isReadable()) {
                this.unprocessed.remove().release();
            }
            return value;
        }
        return this.readIntSlowPath();
    }

    private int readIntSlowPath() {
        assert (this.unprocessed != null);
        int value = 0;
        for (int i = 4; i > 0; --i) {
            ByteBuf buf = this.unprocessed.peek();
            assert (buf != null);
            value <<= 8;
            value |= buf.readUnsignedByte();
            if (buf.isReadable()) continue;
            this.unprocessed.remove().release();
        }
        return value;
    }

    private void readBody() {
        ByteBuf buf = this.readBytes(this.requiredLength);
        boolean isCompressed = (this.currentType & 1) != 0;
        DeframedMessage msg = isCompressed ? this.getCompressedBody(buf) : this.getUncompressedBody(buf);
        this.listener.messageRead(msg);
        this.currentType = -1;
        this.requiredLength = 5;
    }

    private ByteBuf readBytes(int length) {
        if (length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        this.unprocessedBytes -= length;
        assert (this.unprocessed != null);
        ByteBuf firstBuf = this.unprocessed.peek();
        assert (firstBuf != null);
        int firstBufLen = firstBuf.readableBytes();
        if (firstBufLen == length) {
            this.unprocessed.remove();
            return firstBuf;
        }
        if (firstBufLen > length) {
            return firstBuf.readRetainedSlice(length);
        }
        return this.readBytesMerged(length);
    }

    private ByteBuf readBytesMerged(int length) {
        ByteBuf buf;
        int remaining;
        ByteBuf merged;
        block3: {
            int bufLen;
            assert (this.unprocessed != null);
            merged = this.alloc.buffer(length);
            do {
                buf = this.unprocessed.peek();
                assert (buf != null);
                bufLen = buf.readableBytes();
                if (bufLen > (remaining = merged.writableBytes())) break block3;
                merged.writeBytes(buf);
                this.unprocessed.remove().release();
            } while (bufLen != remaining);
            return merged;
        }
        merged.writeBytes(buf, remaining);
        return merged;
    }

    private DeframedMessage getUncompressedBody(ByteBuf buf) {
        return new DeframedMessage(buf, this.currentType);
    }

    private boolean isClosedOrScheduledToClose() {
        return this.isClosed() || this.closeWhenComplete;
    }

    private DeframedMessage getCompressedBody(ByteBuf buf) {
        if (this.decompressor == null) {
            buf.release();
            throw new ArmeriaStatusException(13, DEBUG_STRING + ": Can't decode compressed frame as compression not configured.");
        }
        try {
            InputStream unlimitedStream = this.decompressor.decompress((InputStream)new ByteBufInputStream(buf, true));
            return new DeframedMessage(new SizeEnforcingInputStream(unlimitedStream, this.maxMessageSizeBytes, DEBUG_STRING), this.currentType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static final class SizeEnforcingInputStream
    extends FilterInputStream {
        private final int maxMessageSize;
        private final String debugString;
        private long maxCount;
        private long count;
        private long mark = -1L;

        SizeEnforcingInputStream(InputStream in, int maxMessageSize, String debugString) {
            super(in);
            this.maxMessageSize = maxMessageSize;
            this.debugString = debugString;
        }

        @Override
        public int read() throws IOException {
            int result = this.in.read();
            if (result != -1) {
                ++this.count;
            }
            this.verifySize();
            this.reportCount();
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.in.read(b, off, len);
            if (result != -1) {
                this.count += (long)result;
            }
            this.verifySize();
            this.reportCount();
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            long result = this.in.skip(n);
            this.count += result;
            this.verifySize();
            this.reportCount();
            return result;
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
            this.mark = this.count;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (!this.in.markSupported()) {
                throw new IOException("Mark not supported");
            }
            if (this.mark == -1L) {
                throw new IOException("Mark not set");
            }
            this.in.reset();
            this.count = this.mark;
        }

        private void reportCount() {
            if (this.count > this.maxCount) {
                this.maxCount = this.count;
            }
        }

        private void verifySize() {
            if (this.count > (long)this.maxMessageSize) {
                throw new ArmeriaStatusException(8, String.format("%s: Compressed frame exceeds maximum frame size: %d. Bytes read: %d. ", this.debugString, this.maxMessageSize, this.count));
            }
        }
    }

    public static interface Listener {
        public void messageRead(DeframedMessage var1);

        public void endOfStream();
    }

    public static class DeframedMessage {
        private final int type;
        @Nullable
        private final ByteBuf buf;
        @Nullable
        private final InputStream stream;

        @VisibleForTesting
        public DeframedMessage(ByteBuf buf, int type) {
            this(Objects.requireNonNull(buf, "buf"), null, type);
        }

        @VisibleForTesting
        public DeframedMessage(InputStream stream, int type) {
            this(null, Objects.requireNonNull(stream, "stream"), type);
        }

        private DeframedMessage(@Nullable ByteBuf buf, @Nullable InputStream stream, int type) {
            this.buf = buf;
            this.stream = stream;
            this.type = type;
        }

        @Nullable
        public ByteBuf buf() {
            return this.buf;
        }

        @Nullable
        public InputStream stream() {
            return this.stream;
        }

        public int type() {
            return this.type;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeframedMessage)) {
                return false;
            }
            DeframedMessage that = (DeframedMessage)o;
            return this.type == that.type && Objects.equals(this.buf, that.buf) && Objects.equals(this.stream, that.stream);
        }

        public int hashCode() {
            return Objects.hash(this.buf, this.stream);
        }
    }
}

