/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.tracing;

import brave.Span;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.internal.tracing.SpanTags;
import java.util.concurrent.TimeUnit;

public final class SpanContextUtil {
    public static void startSpan(Span span, RequestLog log) {
        span.start(log.requestStartTimeMicros());
    }

    public static void closeSpan(Span span, RequestLog log) {
        SpanTags.addTags(span, log);
        span.finish(SpanContextUtil.wallTimeMicros(log, log.responseEndTimeNanos()));
    }

    static long wallTimeMicros(RequestLog log, long timeNanos) {
        long relativeTimeNanos = timeNanos - log.requestStartTimeNanos();
        return log.requestStartTimeMicros() + TimeUnit.NANOSECONDS.toMicros(relativeTimeNanos);
    }

    private SpanContextUtil() {
    }
}

