/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark;

import com.lucidworks.spark.util.SolrSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.spark.Partitioner;

public class ShardIndexPartitioner
extends Partitioner
implements Serializable {
    protected String zkHost;
    protected String collection;
    protected String idField;
    protected transient CloudSolrClient cloudSolrServer = null;
    protected transient DocCollection docCollection = null;
    protected transient Map<String, Integer> shardIndexCache = null;

    public ShardIndexPartitioner(String zkHost, String collection) {
        this(zkHost, collection, "id");
    }

    public ShardIndexPartitioner(String zkHost, String collection, String idField) {
        this.zkHost = zkHost;
        this.collection = collection;
        this.idField = idField;
    }

    public int numPartitions() {
        return this.getDocCollection().getActiveSlices().size();
    }

    public String getShardId(SolrInputDocument doc) {
        return this.getShardId((String)doc.getFieldValue(this.idField));
    }

    public String getShardId(String docId) {
        DocCollection dc = this.getDocCollection();
        Slice slice = dc.getRouter().getTargetSlice(docId, null, null, null, dc);
        return slice.getName();
    }

    public int getPartition(Object o) {
        Object docId = null;
        if (o instanceof SolrInputDocument) {
            SolrInputDocument doc = (SolrInputDocument)o;
            docId = doc.getFieldValue(this.idField);
            if (docId == null) {
                throw new IllegalArgumentException("SolrInputDocument must contain a non-null value for " + this.idField);
            }
        } else {
            docId = o;
        }
        if (!(docId instanceof String)) {
            throw new IllegalArgumentException("Only String document IDs are supported by this Partitioner!");
        }
        DocCollection dc = this.getDocCollection();
        Slice slice = dc.getRouter().getTargetSlice((String)docId, null, null, null, dc);
        return this.getShardIndex(slice.getName(), dc);
    }

    protected final synchronized int getShardIndex(String shardId, DocCollection dc) {
        Integer idx;
        if (this.shardIndexCache == null) {
            this.shardIndexCache = new HashMap<String, Integer>(20);
        }
        if ((idx = this.shardIndexCache.get(shardId)) != null) {
            return idx;
        }
        int s = 0;
        for (Slice slice : dc.getSlices()) {
            if (shardId.equals(slice.getName())) {
                this.shardIndexCache.put(shardId, new Integer(s));
                return s;
            }
            ++s;
        }
        throw new IllegalStateException("Cannot find index of shard '" + shardId + "' in collection: " + this.collection);
    }

    protected final synchronized DocCollection getDocCollection() {
        if (this.docCollection == null) {
            ZkStateReader zkStateReader = this.getCloudSolrServer().getZkStateReader();
            this.docCollection = zkStateReader.getClusterState().getCollection(this.collection);
            DocRouter docRouter = this.docCollection.getRouter();
            if (docRouter instanceof ImplicitDocRouter) {
                throw new IllegalStateException("Implicit document routing not supported by this Partitioner!");
            }
            Collection shards = this.getDocCollection().getSlices();
            if (shards == null || shards.size() == 0) {
                throw new IllegalStateException("Collection '" + this.collection + "' does not have any shards!");
            }
        }
        return this.docCollection;
    }

    protected final synchronized CloudSolrClient getCloudSolrServer() {
        if (this.cloudSolrServer == null) {
            this.cloudSolrServer = SolrSupport.getCachedCloudClient(this.zkHost);
        }
        return this.cloudSolrServer;
    }
}

