/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.example.ml;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Locale;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.ISODateTimeFormat;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class DateConverter$
implements Serializable,
LazyLogging {
    public static final DateConverter$ MODULE$;
    private final Map<String, DateTimeZone> ZoneMap;
    private final Regex ZonesRegex;
    private final DateTimeParser[] DateParsers;
    private final DateTimeFormatter Formatter;
    private final Regex MultiSpaceRegex;
    private final Regex TrailingOffsetRegex;
    private final String DayOfWeekPattern;
    private final Regex DowRegex;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new DateConverter$();
    }

    private Logger logger$lzycompute() {
        DateConverter$ dateConverter$ = this;
        synchronized (dateConverter$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Map<String, DateTimeZone> ZoneMap() {
        return this.ZoneMap;
    }

    public Regex ZonesRegex() {
        return this.ZonesRegex;
    }

    public DateTimeParser[] DateParsers() {
        return this.DateParsers;
    }

    public DateTimeFormatter Formatter() {
        return this.Formatter;
    }

    public Regex MultiSpaceRegex() {
        return this.MultiSpaceRegex;
    }

    public Regex TrailingOffsetRegex() {
        return this.TrailingOffsetRegex;
    }

    public String DayOfWeekPattern() {
        return this.DayOfWeekPattern;
    }

    public Regex DowRegex() {
        return this.DowRegex;
    }

    public Option<String> toISO8601(String date) {
        None$ none$;
        try {
            ObjectRef zone = ObjectRef.create((Object)DateTimeZone.UTC);
            String dateSingleSpaced = this.MultiSpaceRegex().replaceAllIn((CharSequence)date, " ");
            String dateNoExtraTrailingOffset = this.TrailingOffsetRegex().replaceFirstIn((CharSequence)dateSingleSpaced, "");
            String dateNoDow = this.DowRegex().replaceFirstIn((CharSequence)dateNoExtraTrailingOffset, "");
            String dateNoZone = this.ZonesRegex().replaceAllIn((CharSequence)dateNoDow, (Function1)new Serializable(zone){
                public static final long serialVersionUID = 0L;
                private final ObjectRef zone$1;

                public final String apply(Regex.Match m) {
                    this.zone$1.elem = (DateTimeZone)DateConverter$.MODULE$.ZoneMap().apply((Object)m.group(1).toUpperCase(Locale.ROOT));
                    return "";
                }
                {
                    this.zone$1 = zone$1;
                }
            });
            none$ = new Some((Object)this.Formatter().withZone((DateTimeZone)zone.elem).parseDateTime(dateNoZone).toString(ISODateTimeFormat.dateTimeNoMillis()));
        }
        catch (Throwable throwable) {
            None$ none$2;
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse date '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{date, e})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = none$2 = None$.MODULE$;
        }
        return none$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DateConverter$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.ZoneMap = (Map)((TraversableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"+3000"), (Object)"Europe/Moscow"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ACST"), (Object)"Australia/Adelaide"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BST"), (Object)"Europe/London"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CDT"), (Object)"America/Chicago"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CET"), (Object)"Europe/Brussels"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CST"), (Object)"America/Chicago"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ECT"), (Object)"America/Guayaquil"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EDT"), (Object)"America/New_York"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EST"), (Object)"America/New_York"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"GMT"), (Object)"Etc/GMT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"GMT+12"), (Object)"Etc/GMT+12"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"IDT"), (Object)"Asia/Jerusalem"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"KST"), (Object)"Asia/Seoul"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MDT"), (Object)"America/Denver"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MET"), (Object)"Europe/Berlin"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MEZ"), (Object)"Europe/Berlin"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MST"), (Object)"America/Denver"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NZDT"), (Object)"Pacific/Auckland"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NZST"), (Object)"Pacific/Auckland"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PDT"), (Object)"America/Los_Angeles"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PST"), (Object)"America/Los_Angeles"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TUR"), (Object)"Asia/Istanbul"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"UT"), (Object)"Etc/UTC"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"UTC"), (Object)"Etc/UTC")}))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, DateTimeZone> apply(Tuple2<String, String> e) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e._1()), (Object)DateTimeZone.forID((String)((String)e._2())));
            }
        }, Map$.MODULE$.canBuildFrom());
        this.ZonesRegex = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\\\s+\\\\(?((?i)", ")\\\\)?$"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.ZoneMap().keys().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String z) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\\\Q", "\\\\E"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{z}));
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString("|")})))).r();
        this.DateParsers = (DateTimeParser[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"dd MMM yy", "dd MMM yy HH:mm", "dd MMM yy HH:mm Z", "dd MMM yy HH:mm:ss", "dd MMM yy HH:mm:ss Z", "MM/dd/yy", "MMM dd, yy", "yyyy-MM-dd HH:mm:ss", "MMM dd HH:mm:ss yy"}).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DateTimeParser apply(String x$5) {
                return DateTimeFormat.forPattern((String)x$5).getParser();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DateTimeParser.class)));
        this.Formatter = new DateTimeFormatterBuilder().append(null, this.DateParsers()).toFormatter().withPivotYear(1970).withLocale(Locale.ENGLISH);
        this.MultiSpaceRegex = new StringOps(Predef$.MODULE$.augmentString("\\s{2,}")).r();
        this.TrailingOffsetRegex = new StringOps(Predef$.MODULE$.augmentString("\\s*\\([-+]\\d{4}\\)$")).r();
        this.DayOfWeekPattern = "(?i:Sun|Mon|Tue(?:s)?|Wed(?:nes)?|Thu(?:rs)?|Fri|Sat(?:ur)?)(?i:day)?";
        this.DowRegex = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",?\\\\s*|\\\\s*\\\\(", "\\\\)$"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.DayOfWeekPattern(), this.DayOfWeekPattern()})))).r();
    }
}

