/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.example.ml;

import com.lucidworks.spark.SparkApp;
import com.lucidworks.spark.analysis.LuceneTextAnalyzer;
import com.lucidworks.spark.example.ml.SVMExample$;
import com.lucidworks.spark.fusion.FusionMLModelSupport;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.spark.SparkConf;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.classification.SVMWithSGD$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.feature.HashingTF;
import org.apache.spark.mllib.feature.Normalizer;
import org.apache.spark.mllib.feature.StandardScaler;
import org.apache.spark.mllib.feature.StandardScalerModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001A<Q!\u0001\u0002\t\u00025\t!b\u0015,N\u000bb\fW\u000e\u001d7f\u0015\t\u0019A!\u0001\u0002nY*\u0011QAB\u0001\bKb\fW\u000e\u001d7f\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u0005QA.^2jI^|'o[:\u000b\u0003-\t1aY8n\u0007\u0001\u0001\"AD\b\u000e\u0003\t1Q\u0001\u0005\u0002\t\u0002E\u0011!b\u0015,N\u000bb\fW\u000e\u001d7f'\ry!\u0003\u0007\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005MI\u0012B\u0001\u000e\u0015\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015ar\u0002\"\u0001\u001e\u0003\u0019a\u0014N\\5u}Q\tQ\u0002C\u0004 \u001f\t\u0007I\u0011\u0001\u0011\u0002)\u0011+e)Q+M)~sU+T0G\u000b\u0006#VKU#T+\u0005\t\u0003C\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\nAA[1wC&\u0011\u0001f\t\u0002\u0007'R\u0014\u0018N\\4\t\r)z\u0001\u0015!\u0003\"\u0003U!UIR!V\u0019R{f*V'`\r\u0016\u000bE+\u0016*F'\u0002Bq\u0001L\bC\u0002\u0013\u0005\u0001%\u0001\fE\u000b\u001a\u000bU\u000b\u0014+`\u001dVku,\u0013+F%\u0006#\u0016j\u0014(T\u0011\u0019qs\u0002)A\u0005C\u00059B)\u0012$B+2#vLT+N?&#VIU!U\u0013>s5\u000b\t\u0005\ba=\u0011\r\u0011\"\u0001!\u00035!UMZ1vYRT6\u000eS8ti\"1!g\u0004Q\u0001\n\u0005\na\u0002R3gCVdGOW6I_N$\b\u0005C\u00045\u001f\t\u0007I\u0011\u0001\u0011\u0002#\u0011+g-Y;mi\u000e{G\u000e\\3di&|g\u000e\u0003\u00047\u001f\u0001\u0006I!I\u0001\u0013\t\u00164\u0017-\u001e7u\u0007>dG.Z2uS>t\u0007\u0005C\u00049\u001f\u0005\u0005I\u0011B\u001d\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002uA\u0011!eO\u0005\u0003y\r\u0012aa\u00142kK\u000e$h\u0001\u0002\t\u0003\u0001y\u001a2!\u0010\n@!\t\u0001EI\u0004\u0002B\u00056\ta!\u0003\u0002D\r\u0005A1\u000b]1sW\u0006\u0003\b/\u0003\u0002F\r\na!\u000b\u0012#Qe>\u001cWm]:pe*\u00111I\u0002\u0005\u00069u\"\t\u0001\u0013\u000b\u0002\u0013B\u0011a\"\u0010\u0005\u0006\u0017v\"\t\u0001T\u0001\bO\u0016$h*Y7f)\u0005\t\u0003\"\u0002(>\t\u0003y\u0015AC4fi>\u0003H/[8ogR\t\u0001\u000bE\u0002\u0014#NK!A\u0015\u000b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005QkV\"A+\u000b\u0005Y;\u0016aA2mS*\u0011\u0001,W\u0001\bG>lWn\u001c8t\u0015\tQ6,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0006\u0019qN]4\n\u0005y+&AB(qi&|g\u000eC\u0003a{\u0011\u0005\u0013-A\u0002sk:$2AY3m!\t\u00192-\u0003\u0002e)\t\u0019\u0011J\u001c;\t\u000b\u0019|\u0006\u0019A4\u0002\t\r|gN\u001a\t\u0003Q*l\u0011!\u001b\u0006\u0003\u000feK!a[5\u0003\u0013M\u0003\u0018M]6D_:4\u0007\"\u0002,`\u0001\u0004i\u0007C\u0001+o\u0013\tyWKA\u0006D_6l\u0017M\u001c3MS:,\u0007")
public class SVMExample
implements SparkApp.RDDProcessor {
    public static String DefaultCollection() {
        return SVMExample$.MODULE$.DefaultCollection();
    }

    public static String DefaultZkHost() {
        return SVMExample$.MODULE$.DefaultZkHost();
    }

    public static String DEFAULT_NUM_ITERATIONS() {
        return SVMExample$.MODULE$.DEFAULT_NUM_ITERATIONS();
    }

    public static String DEFAULT_NUM_FEATURES() {
        return SVMExample$.MODULE$.DEFAULT_NUM_FEATURES();
    }

    @Override
    public String getName() {
        return "mllib-svm-scala";
    }

    @Override
    public Option[] getOptions() {
        return (Option[])((Object[])new Option[]{Option.builder().longOpt("indexTrainingData").hasArg().required(false).desc(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Path to training data to index"})).s((Seq)Nil$.MODULE$)).build(), Option.builder().longOpt("indexTestData").hasArg().required(false).desc(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Path to test data to index"})).s((Seq)Nil$.MODULE$)).build(), Option.builder().longOpt("sample").hasArg().required(false).desc(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fraction (0 to 1) of full dataset to sample from Solr, default is 1"})).s((Seq)Nil$.MODULE$)).build(), Option.builder().longOpt("numFeatures").hasArg().required(false).desc(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of features; default is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SVMExample$.MODULE$.DEFAULT_NUM_FEATURES()}))).build(), Option.builder().longOpt("numIterations").hasArg().required(false).desc(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of iterations; default is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SVMExample$.MODULE$.DEFAULT_NUM_ITERATIONS()}))).build(), Option.builder().longOpt("modelOutput").hasArg().required(false).desc(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Model output path; default is mllib-svm-sentiment"})).s((Seq)Nil$.MODULE$)).build(), Option.builder().longOpt("fusionHostAndPort").hasArg().required(false).desc(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fusion host and port; Example localhost:8764"})).s((Seq)Nil$.MODULE$)).build(), Option.builder().longOpt("fusionUser").hasArg().required(false).desc(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fusion user name"})).s((Seq)Nil$.MODULE$)).build(), Option.builder().longOpt("fusionPassword").hasArg().required(false).desc(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fusion password"})).s((Seq)Nil$.MODULE$)).build(), Option.builder().longOpt("fusionRealm").hasArg().required(false).desc(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fusion Realm"})).s((Seq)Nil$.MODULE$)).build()});
    }

    @Override
    public int run(SparkConf conf, CommandLine cli) {
        String indexTestData;
        SparkSession sparkSession = SparkSession$.MODULE$.builder().config(conf).getOrCreate();
        StructField structField = new StructField("polarity", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("id", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("date", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("query", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField5 = new StructField("username", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("tweet_txt", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructType csvSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6).$colon$colon((Object)structField5).$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
        HashMap writeoptions = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zkhost"), (Object)cli.getOptionValue("zkHost", SVMExample$.MODULE$.DefaultZkHost())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collection"), (Object)cli.getOptionValue("collection", SVMExample$.MODULE$.DefaultCollection())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"soft_commit_secs"), (Object)"10")}));
        String indexTrainingData = cli.getOptionValue("indexTrainingData");
        if (indexTrainingData != null) {
            Dataset csvDF = sparkSession.read().format("com.databricks.spark.csv").schema(csvSchema).option("header", "false").load(indexTrainingData);
            csvDF = csvDF.repartition(4);
            csvDF.write().format("solr").options((Map)writeoptions).mode(SaveMode.Overwrite).save();
        }
        if ((indexTestData = cli.getOptionValue("indexTestData")) != null) {
            Dataset csvDF = sparkSession.read().format("com.databricks.spark.csv").schema(csvSchema).option("header", "false").load(indexTestData);
            csvDF = csvDF.withColumnRenamed("polarity", "test_polarity");
            csvDF.write().format("solr").options((Map)writeoptions).mode(SaveMode.Overwrite).save();
        }
        String contentFields = "tweet_txt";
        HashMap trainoptions = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zkhost"), (Object)cli.getOptionValue("zkHost", SVMExample$.MODULE$.DefaultZkHost())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collection"), (Object)cli.getOptionValue("collection", SVMExample$.MODULE$.DefaultCollection())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"query"), (Object)"+polarity:(0 OR 4) +tweet_txt:[* TO *]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)"id,polarity,tweet_txt"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rows"), (Object)"10000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"splits"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"split_field"), (Object)"_version_"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"splits_per_shard"), (Object)"8")}));
        double sampleFraction = new StringOps(Predef$.MODULE$.augmentString(cli.getOptionValue("sample", "1.0"))).toDouble();
        Dataset trainingDataFromSolr = sparkSession.read().format("solr").options((Map)trainoptions).load();
        trainingDataFromSolr = trainingDataFromSolr.sample(false, sampleFraction);
        String[] inputCols = (String[])Predef$.MODULE$.refArrayOps((Object[])contentFields.split(" ")).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$7) {
                return x$7.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String stdTokLowerSchema = "{ \"analyzers\": [{ \"name\": \"std_tok_lower\", \"tokenizer\": { \"type\": \"standard\" },\n                \"filters\": [{ \"type\": \"lowercase\" }]}],\n  \"fields\": [{ \"regex\": \".+\", \"analyzer\": \"std_tok_lower\" }]}\n";
        int numFeatures = new StringOps(Predef$.MODULE$.augmentString(cli.getOptionValue("numFeatures", SVMExample$.MODULE$.DEFAULT_NUM_FEATURES()))).toInt();
        int numIterations = new StringOps(Predef$.MODULE$.augmentString(cli.getOptionValue("numIterations", SVMExample$.MODULE$.DEFAULT_NUM_ITERATIONS()))).toInt();
        RDD trainingData = trainingDataFromSolr.rdd().map((Function1)new Serializable(this, inputCols, stdTokLowerSchema, numFeatures){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SVMExample $outer;
            private final String[] inputCols$1;
            private final String stdTokLowerSchema$1;
            private final int numFeatures$1;

            public final LabeledPoint apply(Row row) {
                return this.$outer.com$lucidworks$spark$example$ml$SVMExample$$RowtoLab$1(row, this.numFeatures$1, this.inputCols$1, this.stdTokLowerSchema$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputCols$1 = inputCols$1;
                this.stdTokLowerSchema$1 = stdTokLowerSchema$1;
                this.numFeatures$1 = numFeatures$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        ObjectRef standardScaler = ObjectRef.create((Object)new StandardScaler().fit(trainingData.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Vector apply(LabeledPoint x) {
                return x.features();
            }
        }, ClassTag$.MODULE$.apply(Vector.class))));
        RDD trainRDD = trainingData.map((Function1)new Serializable(this, standardScaler){
            public static final long serialVersionUID = 0L;
            private final ObjectRef standardScaler$1;

            public final LabeledPoint apply(LabeledPoint x) {
                return new LabeledPoint(x.label(), ((StandardScalerModel)this.standardScaler$1.elem).transform(x.features()));
            }
            {
                this.standardScaler$1 = standardScaler$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        trainRDD = trainRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY_SER());
        SVMModel model = SVMWithSGD$.MODULE$.train(trainRDD, numIterations);
        HashMap testoptions = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zkhost"), (Object)cli.getOptionValue("zkHost", SVMExample$.MODULE$.DefaultZkHost())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collection"), (Object)cli.getOptionValue("collection", SVMExample$.MODULE$.DefaultCollection())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"query"), (Object)"+test_polarity:[* TO *] +tweet_txt:[* TO *]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)"id,test_polarity,tweet_txt")}));
        Dataset testDataFromSolr = sparkSession.read().format("solr").options((Map)testoptions).load();
        testDataFromSolr = testDataFromSolr.withColumnRenamed("test_polarity", "polarity");
        testDataFromSolr.show();
        RDD testVectors = testDataFromSolr.rdd().map((Function1)new Serializable(this, inputCols, stdTokLowerSchema, numFeatures){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SVMExample $outer;
            private final String[] inputCols$1;
            private final String stdTokLowerSchema$1;
            private final int numFeatures$1;

            public final LabeledPoint apply(Row row) {
                return this.$outer.com$lucidworks$spark$example$ml$SVMExample$$RowtoLab$1(row, this.numFeatures$1, this.inputCols$1, this.stdTokLowerSchema$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputCols$1 = inputCols$1;
                this.stdTokLowerSchema$1 = stdTokLowerSchema$1;
                this.numFeatures$1 = numFeatures$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)).map((Function1)new Serializable(this, standardScaler){
            public static final long serialVersionUID = 0L;
            private final ObjectRef standardScaler$1;

            public final LabeledPoint apply(LabeledPoint x) {
                return new LabeledPoint(x.label(), ((StandardScalerModel)this.standardScaler$1.elem).transform(x.features()));
            }
            {
                this.standardScaler$1 = standardScaler$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        RDD scoreAndLabels = testVectors.map((Function1)new Serializable(this, model){
            public static final long serialVersionUID = 0L;
            private final SVMModel model$1;

            public final Tuple2<Object, Object> apply(LabeledPoint p) {
                double score = this.model$1.predict(p.features());
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)">> model predicted: ").append((Object)BoxesRunTime.boxToDouble((double)score)).append((Object)", actual: ").append((Object)BoxesRunTime.boxToDouble((double)p.label())).toString());
                return new Tuple2.mcDD.sp(score, p.label());
            }
            {
                this.model$1 = model$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(scoreAndLabels);
        double auROC = metrics.areaUnderROC();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Area under ROC = ").append((Object)BoxesRunTime.boxToDouble((double)auROC)).toString());
        if (cli.getOptionValue("fusionHostAndPort") == null) {
            model.save(sparkSession.sparkContext(), cli.getOptionValue("modelOutput", "mllib-svm-sentiment"));
        } else {
            java.util.HashMap<String, String> metadata = new java.util.HashMap<String, String>();
            metadata.put("numFeatures", "1000000");
            metadata.put("featureFields", "tweet_txt");
            metadata.put("analyzerJson", stdTokLowerSchema);
            metadata.put("normalizer", "Y");
            metadata.put("standardscaler", "Y");
            metadata.put("mean", ((StandardScalerModel)standardScaler.elem).mean().toString());
            metadata.put("std", ((StandardScalerModel)standardScaler.elem).std().toString());
            if (cli.getOptionValue("fusionUser") == null || cli.getOptionValue("fusionPassword") == null) {
                FusionMLModelSupport.saveModelInLocalFusion(sparkSession.sparkContext(), cli.getOptionValue("modelOutput", "mllib-svm-sentiment"), model, metadata);
            } else {
                FusionMLModelSupport.saveModelInFusion(cli.getOptionValue("fusionHostAndPort"), cli.getOptionValue("fusionUser"), cli.getOptionValue("fusionPassword"), cli.getOptionValue("fusionRealm", "native"), sparkSession.sparkContext(), cli.getOptionValue("modelOutput", "mllib-svm-sentiment"), model, metadata);
            }
        }
        return 0;
    }

    public final LabeledPoint com$lucidworks$spark$example$ml$SVMExample$$RowtoLab$1(Row row, int numFeatures, String[] inputCols, String stdTokLowerSchema) {
        LuceneTextAnalyzer textAnalyzer = new LuceneTextAnalyzer(stdTokLowerSchema);
        HashingTF hashingTF = new HashingTF(numFeatures);
        Normalizer normalizer = new Normalizer();
        String polarity = row.getString(row.fieldIndex("polarity"));
        ObjectRef fields = ObjectRef.create(new java.util.HashMap());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), inputCols.length).foreach((Function1)new Serializable(this, row, inputCols, fields){
            public static final long serialVersionUID = 0L;
            private final Row row$1;
            private final String[] inputCols$2;
            private final ObjectRef fields$1;

            public final Object apply(int i) {
                String value = this.row$1.getString(this.row$1.fieldIndex(this.inputCols$2[i]));
                return value == null ? BoxedUnit.UNIT : ((java.util.HashMap)this.fields$1.elem).put(this.inputCols$2[i], value);
            }
            {
                this.row$1 = row$1;
                this.inputCols$2 = inputCols$2;
                this.fields$1 = fields$1;
            }
        });
        java.util.Map<String, List<String>> analyzedFields = textAnalyzer.analyzeJava((java.util.HashMap)fields.elem);
        ObjectRef terms = ObjectRef.create(new LinkedList());
        ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(analyzedFields.values()).asScala()).toList().foreach((Function1)new Serializable(this, terms){
            public static final long serialVersionUID = 0L;
            private final ObjectRef terms$1;

            public final boolean apply(List<String> v) {
                return ((LinkedList)this.terms$1.elem).addAll(v);
            }
            {
                this.terms$1 = terms$1;
            }
        });
        double sentimentLabel = "0".equals(polarity) ? 0.0 : 1.0;
        return new LabeledPoint(sentimentLabel, normalizer.transform(hashingTF.transform((Iterable)((LinkedList)terms.elem))));
    }
}

