/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.example.movies;

import com.google.common.util.concurrent.RateLimiter;
import com.lucidworks.spark.util.SolrJsonSupport;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.map.ObjectMapper;

public class OmdbApi {
    private static final RateLimiter rateLimiter = RateLimiter.create((double)10.0);
    private static HttpClient httpClient = null;
    private static ObjectMapper objectMapper = new ObjectMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpClient getHttpClient() {
        Class<OmdbApi> clazz = OmdbApi.class;
        synchronized (OmdbApi.class) {
            if (httpClient == null) {
                httpClient = SolrJsonSupport.getHttpClient();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpClient;
        }
    }

    public static Map<String, Object> byTitle(String title, String year) throws Exception {
        HttpClient http = OmdbApi.getHttpClient();
        String getUri = "http://www.omdbapi.com/?t=" + URLEncoder.encode(title) + "&y=" + URLEncoder.encode(year) + "&plot=full&r=json";
        HttpGet get = new HttpGet(getUri);
        rateLimiter.acquire();
        System.out.println("Sending GET request to: " + get.toString());
        HttpResponse resp = http.execute((HttpUriRequest)get);
        String rawJson = SolrJsonSupport.getHttpResponseAsString(resp.getEntity());
        return (Map)objectMapper.readValue(rawJson, Map.class);
    }
}

