/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.example.query;

import com.lucidworks.spark.SparkApp;
import com.lucidworks.spark.rdd.SolrRDD;
import com.lucidworks.spark.rdd.SolrRDD$;
import com.lucidworks.spark.util.SolrSupport$;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000193A!\u0001\u0002\u0001\u001b\tq\u0011+^3ss\n+gn\u00195nCJ\\'BA\u0002\u0005\u0003\u0015\tX/\u001a:z\u0015\t)a!A\u0004fq\u0006l\u0007\u000f\\3\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003)aWoY5eo>\u00148n\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)\u0012D\u0004\u0002\u0017/5\ta!\u0003\u0002\u0019\r\u0005A1\u000b]1sW\u0006\u0003\b/\u0003\u0002\u001b7\ta!\u000b\u0012#Qe>\u001cWm]:pe*\u0011\u0001D\u0002\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\tAQA\t\u0001\u0005\u0002\r\nqaZ3u\u001d\u0006lW\rF\u0001%!\t)\u0003F\u0004\u0002\u0010M%\u0011q\u0005E\u0001\u0007!J,G-\u001a4\n\u0005%R#AB*ue&twM\u0003\u0002(!!)A\u0006\u0001C\u0001[\u0005Qq-\u001a;PaRLwN\\:\u0015\u00039\u00022aD\u00182\u0013\t\u0001\u0004CA\u0003BeJ\f\u0017\u0010\u0005\u00023w5\t1G\u0003\u00025k\u0005\u00191\r\\5\u000b\u0005Y:\u0014aB2p[6|gn\u001d\u0006\u0003qe\na!\u00199bG\",'\"\u0001\u001e\u0002\u0007=\u0014x-\u0003\u0002=g\t1q\n\u001d;j_:DQA\u0010\u0001\u0005\u0002}\n1A];o)\r\u00015I\u0013\t\u0003\u001f\u0005K!A\u0011\t\u0003\u0007%sG\u000fC\u0003E{\u0001\u0007Q)\u0001\u0003d_:4\u0007C\u0001$I\u001b\u00059%BA\u00048\u0013\tIuIA\u0005Ta\u0006\u00148nQ8oM\")A'\u0010a\u0001\u0017B\u0011!\u0007T\u0005\u0003\u001bN\u00121bQ8n[\u0006tG\rT5oK\u0002")
public class QueryBenchmark
implements SparkApp.RDDProcessor {
    @Override
    public String getName() {
        return "query-solr-benchmark";
    }

    @Override
    public Option[] getOptions() {
        return (Option[])((Object[])new Option[]{Option.builder().longOpt("query").hasArg().required(false).desc("URL encoded Solr query to send to Solr, default is *:* (all docs)").build(), Option.builder().longOpt("rows").hasArg().required(false).desc("Number of rows to fetch at once, default is 1000").build(), Option.builder().longOpt("splitsPerShard").hasArg().required(false).desc("Number of splits per shard, default is 3").build(), Option.builder().longOpt("splitField").hasArg().required(false).desc("Name of an indexed numeric field (preferably long type) used to split a shard, default is _version_").build(), Option.builder().longOpt("fields").hasArg().required(false).desc("Comma-delimited list of fields to be returned from the query; default is all fields").build()});
    }

    @Override
    public int run(SparkConf conf, CommandLine cli) {
        String zkHost = cli.getOptionValue("zkHost", "localhost:9983");
        String collection = cli.getOptionValue("collection", "collection1");
        String queryStr = cli.getOptionValue("query", "*:*");
        int rows = new StringOps(Predef$.MODULE$.augmentString(cli.getOptionValue("rows", "1000"))).toInt();
        int splitsPerShard = new StringOps(Predef$.MODULE$.augmentString(cli.getOptionValue("splitsPerShard", "3"))).toInt();
        String splitField = cli.getOptionValue("splitField", "_version_");
        SparkContext sc = new SparkContext(conf);
        SolrQuery solrQuery = new SolrQuery(queryStr);
        String fields = cli.getOptionValue("fields", "");
        if (!fields.isEmpty()) {
            Predef$.MODULE$.refArrayOps((Object[])fields.split(",")).foreach((Function1)new Serializable(this, solrQuery){
                public static final long serialVersionUID = 0L;
                private final SolrQuery solrQuery$1;

                public final SolrQuery apply(String x$1) {
                    return this.solrQuery$1.addField(x$1);
                }
                {
                    this.solrQuery$1 = solrQuery$1;
                }
            });
        }
        solrQuery.addSort(new SolrQuery.SortClause("id", "asc"));
        solrQuery.setRows(Predef$.MODULE$.int2Integer(rows));
        SolrRDD solrRDD = new SolrRDD(zkHost, collection, sc, SolrRDD$.MODULE$.$lessinit$greater$default$4(), SolrRDD$.MODULE$.$lessinit$greater$default$5(), SolrRDD$.MODULE$.$lessinit$greater$default$6(), SolrRDD$.MODULE$.$lessinit$greater$default$7(), SolrRDD$.MODULE$.$lessinit$greater$default$8(), SolrRDD$.MODULE$.$lessinit$greater$default$9(), SolrRDD$.MODULE$.$lessinit$greater$default$10());
        long startMs = System.currentTimeMillis();
        long count = solrRDD.query(solrQuery).splitField(splitField).splitsPerShard(splitsPerShard).count();
        long tookMs = System.currentTimeMillis() - startMs;
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nTook ", " ms read ", " docs using queryShards with ", " splits"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)tookMs), BoxesRunTime.boxToLong((long)count), BoxesRunTime.boxToInteger((int)splitsPerShard)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nReloading collection ", " to flush caches!\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{collection})));
        CloudSolrClient cloudSolrClient = SolrSupport$.MODULE$.getCachedCloudClient(zkHost);
        CollectionAdminRequest.Reload req = new CollectionAdminRequest.Reload();
        req.setCollectionName(collection);
        cloudSolrClient.request((SolrRequest)req);
        startMs = System.currentTimeMillis();
        count = solrRDD.query(solrQuery).count();
        tookMs = System.currentTimeMillis() - startMs;
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nTook ", " ms read ", " docs using queryShards"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)tookMs), BoxesRunTime.boxToLong((long)count)})));
        sc.stop();
        return 0;
    }
}

