/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.example.query;

import com.lucidworks.spark.SparkApp;
import com.lucidworks.spark.rdd.SolrJavaRDD;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;

public class ReadTermVectors
implements SparkApp.RDDProcessor {
    @Override
    public String getName() {
        return "term-vectors";
    }

    @Override
    public Option[] getOptions() {
        Option[] optionArray = new Option[5];
        OptionBuilder.withArgName((String)"QUERY");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"URL encoded Solr query to send to Solr; default is *:*");
        optionArray[0] = OptionBuilder.create((String)"query");
        OptionBuilder.withArgName((String)"FIELD");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Field to generate term vectors from");
        optionArray[1] = OptionBuilder.create((String)"field");
        OptionBuilder.withArgName((String)"NUM");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Number of features; defaults to 500");
        optionArray[2] = OptionBuilder.create((String)"numFeatures");
        OptionBuilder.withArgName((String)"NUM");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Number of iterations for K-Means clustering; defaults to 20");
        optionArray[3] = OptionBuilder.create((String)"numIterations");
        OptionBuilder.withArgName((String)"NUM");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Number of clusters (k) for K-Means clustering; defaults to 5");
        optionArray[4] = OptionBuilder.create((String)"numClusters");
        return optionArray;
    }

    @Override
    public int run(SparkConf conf, CommandLine cli) throws Exception {
        String zkHost = cli.getOptionValue("zkHost", "localhost:9983");
        String collection = cli.getOptionValue("collection", "collection1");
        String queryStr = cli.getOptionValue("query", "*:*");
        String field = cli.getOptionValue("field");
        int numFeatures = Integer.parseInt(cli.getOptionValue("numFeatures", "500"));
        int numClusters = Integer.parseInt(cli.getOptionValue("numClusters", "5"));
        int numIterations = Integer.parseInt(cli.getOptionValue("numIterations", "20"));
        JavaSparkContext jsc = new JavaSparkContext(conf);
        SolrQuery solrQuery = new SolrQuery(queryStr);
        solrQuery.setFields(new String[]{"id"});
        ArrayList<SolrQuery.SortClause> sorts = new ArrayList<SolrQuery.SortClause>();
        sorts.add(new SolrQuery.SortClause("id", "asc"));
        sorts.add(new SolrQuery.SortClause("created_at_tdt", "asc"));
        solrQuery.setSorts(sorts);
        SolrJavaRDD solrRDD = SolrJavaRDD.get(zkHost, collection, jsc.sc());
        jsc.stop();
        return 0;
    }
}

