/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.fusion;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lucidworks.spark.fusion.FusionPipelineClient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.mllib.util.Saveable;

public class FusionMLModelSupport {
    public static Logger log = Logger.getLogger(FusionMLModelSupport.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveModelInFusion(String fusionHostAndPort, String fusionUser, String fusionPassword, String fusionRealm, SparkContext sc, String modelId, Object model, Map<String, String> metadata) throws Exception {
        HashMap<String, String> mutableMetadata = new HashMap<String, String>();
        mutableMetadata.putAll(metadata);
        File zipFile = FusionMLModelSupport.buildModelArchive(sc, modelId, model, mutableMetadata);
        HttpPut putRequest = FusionMLModelSupport.buildPutRequestToFusion(modelId, fusionHostAndPort, mutableMetadata, zipFile, "/api/apollo");
        FusionPipelineClient fusionClient = new FusionPipelineClient(putRequest.getRequestLine().getUri(), fusionUser, fusionPassword, fusionRealm);
        HttpEntity entity = null;
        try {
            entity = fusionClient.sendRequestToFusion((HttpUriRequest)putRequest);
        }
        finally {
            if (entity != null) {
                try {
                    EntityUtils.consume((HttpEntity)entity);
                }
                catch (Exception ignore) {
                    log.warn((Object)("Failed to consume entity due to: " + ignore));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveModelInLocalFusion(SparkContext sc, String modelId, Object model, Map<String, String> metadata) throws Exception {
        HashMap<String, String> mutableMetadata = new HashMap<String, String>();
        mutableMetadata.putAll(metadata);
        File zipFile = FusionMLModelSupport.buildModelArchive(sc, modelId, model, mutableMetadata);
        HttpPut putRequest = FusionMLModelSupport.buildPutRequestToFusion(modelId, "localhost:8765", mutableMetadata, zipFile, "/api/v1");
        FusionPipelineClient fusionClient = new FusionPipelineClient(putRequest.getRequestLine().getUri());
        HttpEntity entity = null;
        try {
            entity = fusionClient.sendRequestToFusion((HttpUriRequest)putRequest);
        }
        finally {
            if (entity != null) {
                try {
                    EntityUtils.consume((HttpEntity)entity);
                }
                catch (Exception ignore) {
                    log.warn((Object)("Failed to consume entity due to: " + ignore));
                }
            }
        }
    }

    public static HttpPut buildPutRequestToFusion(String modelId, String fusionHostAndPort, HashMap<String, String> mutableMetadata, File zipFile, String fusionApiPath) throws Exception {
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : mutableMetadata.entrySet()) {
            pairs.add(new BasicNameValuePair(entry.getKey(), URLEncoder.encode(entry.getValue(), "UTF-8")));
        }
        String[] pair = fusionHostAndPort.split(":");
        String fusionHost = fusionHostAndPort;
        int fusionPort = 8764;
        if (pair.length == 2) {
            fusionHost = pair[0];
            fusionPort = Integer.parseInt(pair[1]);
        }
        URIBuilder builder = new URIBuilder();
        builder.setScheme("http").setHost(fusionHost).setPort(fusionPort).setPath(fusionApiPath + "/blobs/" + modelId).setParameters(pairs);
        HttpPut putRequest = new HttpPut(builder.build());
        putRequest.setHeader("Content-Type", "application/zip");
        EntityBuilder entityBuilder = EntityBuilder.create();
        entityBuilder.setContentType(ContentType.create((String)"application/zip"));
        entityBuilder.setFile(zipFile);
        putRequest.setEntity(entityBuilder.build());
        return putRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File buildModelArchive(SparkContext sc, String modelId, Object model, HashMap<String, String> metadata) throws Exception {
        String modelType = metadata.get("modelType");
        File modelDir = FusionMLModelSupport.getModelDir(modelId);
        if (model instanceof Saveable) {
            ((Saveable)model).save(sc, modelDir.getAbsolutePath());
            if (modelType == null) {
                modelType = "spark-mllib";
                metadata.put("modelType", modelType);
            }
        } else if (model instanceof MLWritable) {
            ((MLWritable)model).write().overwrite().save(modelDir.getAbsolutePath());
            if (modelType == null) {
                modelType = "spark-ml";
                metadata.put("modelType", modelType);
            }
        } else {
            throw new IllegalArgumentException("Provided ML model of type " + model.getClass().getName() + " does not implement " + Saveable.class.getName() + " or " + MLWritable.class.getName() + "!");
        }
        LinkedHashMap<String, Object> modelJson = new LinkedHashMap<String, Object>();
        modelJson.put("id", modelId);
        modelJson.put("modelType", modelType);
        modelJson.put("modelClassName", model.getClass().getName());
        metadata.remove("modelClassName");
        String featureFields = metadata.get("featureFields");
        if (featureFields != null) {
            modelJson.put("featureFields", Arrays.asList(featureFields.split(",")));
            metadata.remove("featureFields");
        }
        ObjectMapper om = new ObjectMapper();
        if ("spark-mllib".equals(modelType)) {
            ArrayList vectorizerSteps = new ArrayList();
            String analyzerJson = metadata.get("analyzerJson");
            Map analyzerJsonMap = (Map)om.readValue(analyzerJson, Map.class);
            HashMap<String, Map> luceneAnalyzer = new HashMap<String, Map>();
            luceneAnalyzer.put("lucene-analyzer", analyzerJsonMap);
            vectorizerSteps.add(luceneAnalyzer);
            metadata.remove("analyzerJson");
            HashMap<String, String> hashingTFMap = new HashMap<String, String>();
            hashingTFMap.put("numFeatures", metadata.get("numFeatures"));
            HashMap<String, HashMap<String, String>> hashingTF = new HashMap<String, HashMap<String, String>>();
            hashingTF.put("hashingTF", hashingTFMap);
            vectorizerSteps.add(hashingTF);
            metadata.remove("numFeatures");
            if (metadata.containsKey("normalizer")) {
                HashMap<String, String> normalizerMap = new HashMap<String, String>();
                if (metadata.containsKey("p-norm")) {
                    normalizerMap.put("p-norm", metadata.get("p-norm"));
                }
                HashMap<String, HashMap<String, String>> normalizer = new HashMap<String, HashMap<String, String>>();
                normalizer.put("normalizer", normalizerMap);
                vectorizerSteps.add(normalizer);
                metadata.remove("p-norm");
                metadata.remove("normalizer");
            }
            if (metadata.containsKey("standardscaler")) {
                HashMap<String, String> standardScalerMap = new HashMap<String, String>();
                if (metadata.containsKey("withMean")) {
                    standardScalerMap.put("withMean", metadata.get("withMean"));
                }
                if (metadata.containsKey("withStd")) {
                    standardScalerMap.put("withStd", metadata.get("withStd"));
                }
                standardScalerMap.put("mean", metadata.get("mean"));
                standardScalerMap.put("std", metadata.get("std"));
                HashMap<String, HashMap<String, String>> standardScaler = new HashMap<String, HashMap<String, String>>();
                standardScaler.put("standardScaler", standardScalerMap);
                vectorizerSteps.add(standardScaler);
                metadata.remove("withMean");
                metadata.remove("withStd");
                metadata.remove("mean");
                metadata.remove("std");
                metadata.remove("standardscaler");
            }
            if (metadata.containsKey("chisqselector")) {
                HashMap<String, String> chisqselectorMap = new HashMap<String, String>();
                chisqselectorMap.put("numtopfeatures", metadata.get("numtopfeatures"));
                chisqselectorMap.put("selectedfeatures", metadata.get("selectedfeatures"));
                HashMap<String, HashMap<String, String>> chisqSelector = new HashMap<String, HashMap<String, String>>();
                chisqSelector.put("chisqselector", chisqselectorMap);
                vectorizerSteps.add(chisqSelector);
                metadata.remove("numtopfeatures");
                metadata.remove("selectedfeatures");
                metadata.remove("chisqselector");
            }
            modelJson.put("vectorizer", vectorizerSteps);
        }
        File modelJsonFile = new File(modelDir, modelType + ".json");
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(modelJsonFile), StandardCharsets.UTF_8);
            om.writeValue((Writer)osw, modelJson);
        }
        finally {
            if (osw != null) {
                try {
                    osw.flush();
                }
                catch (IOException analyzerJsonMap) {}
                try {
                    osw.close();
                }
                catch (IOException analyzerJsonMap) {}
            }
        }
        metadata.put("modelSpec", modelJsonFile.getName());
        File zipFile = new File(modelId + ".zip");
        if (zipFile.isFile()) {
            zipFile.delete();
        }
        FusionMLModelSupport.addFilesToZip(modelDir, zipFile);
        return zipFile;
    }

    protected static File getModelDir(String modelId) {
        File modelDir = new File(modelId);
        if (modelDir.isDirectory()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
            modelDir.renameTo(new File(modelId + "-bak-" + sdf.format(new Date())));
        }
        if (!modelDir.isDirectory()) {
            modelDir.mkdirs();
        }
        return modelDir;
    }

    protected static void addFilesToZip(File source, File destination) throws IOException, ArchiveException {
        FileOutputStream archiveStream = new FileOutputStream(destination);
        ArchiveOutputStream archive = new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)archiveStream);
        Collection fileList = FileUtils.listFiles((File)source, null, (boolean)true);
        for (File file : fileList) {
            String entryName = FusionMLModelSupport.getEntryName(source, file);
            ZipArchiveEntry entry = new ZipArchiveEntry(entryName);
            archive.putArchiveEntry((ArchiveEntry)entry);
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            IOUtils.copy((InputStream)input, (OutputStream)archive);
            input.close();
            archive.closeArchiveEntry();
        }
        archive.finish();
        ((OutputStream)archiveStream).close();
    }

    protected static String getEntryName(File source, File file) throws IOException {
        int index = source.getAbsolutePath().length() + 1;
        String path = file.getCanonicalPath();
        return path.substring(index);
    }
}

