/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.fusion;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.Krb5HttpClientConfigurer;
import org.apache.solr.common.SolrException;

public class FusionPipelineClient {
    private static final Log log = LogFactory.getLog(FusionPipelineClient.class);
    public static final String PIPELINE_DOC_CONTENT_TYPE = "application/vnd.lucidworks-document";
    public static final String LWWW_JAAS_FILE = "lww.jaas.file";
    public static final String LWWW_JAAS_APPNAME = "lww.jaas.appname";
    List<String> originalHostAndPortList;
    RequestConfig globalConfig;
    CookieStore cookieStore;
    CloseableHttpClient httpClient;
    Map<String, FusionSession> sessions;
    Random random;
    ObjectMapper jsonObjectMapper;
    String fusionUser = null;
    String fusionPass = null;
    String fusionRealm = null;
    AtomicInteger requestCounter = null;
    Map<String, Meter> metersByHost = new HashMap<String, Meter>();
    boolean isKerberos = false;
    MetricRegistry metrics = null;
    static long maxNanosOfInactivity = TimeUnit.NANOSECONDS.convert(599L, TimeUnit.SECONDS);

    public static void setSecurityConfig(String jassFile) {
        if (jassFile == null) {
            return;
        }
        log.info((Object)"Using kerberized Solr.");
        System.setProperty("sun.security.krb5.debug", "true");
        System.setProperty("java.security.auth.login.config", jassFile);
        String appname = System.getProperty(LWWW_JAAS_APPNAME, "Client");
        System.setProperty("solr.kerberos.jaas.appname", appname);
        HttpClientUtil.setConfigurer((HttpClientConfigurer)new Krb5HttpClientConfigurer());
    }

    public FusionPipelineClient(String fusionHostAndPortList) throws MalformedURLException {
        this(fusionHostAndPortList, null, null, null);
    }

    public FusionPipelineClient(String fusionHostAndPortList, String fusionUser, String fusionPass, String fusionRealm) throws MalformedURLException {
        this.fusionUser = fusionUser;
        this.fusionPass = fusionPass;
        this.fusionRealm = fusionRealm;
        String lwwJaasFile = System.getProperty(LWWW_JAAS_FILE);
        if (lwwJaasFile != null && !lwwJaasFile.isEmpty()) {
            FusionPipelineClient.setSecurityConfig(lwwJaasFile);
            this.httpClient = HttpClientUtil.createClient(null);
            HttpClientUtil.setMaxConnections((HttpClient)this.httpClient, (int)1000);
            HttpClientUtil.setMaxConnectionsPerHost((HttpClient)this.httpClient, (int)1000);
            this.isKerberos = true;
        } else {
            this.globalConfig = RequestConfig.custom().setCookieSpec("best-match").build();
            this.cookieStore = new BasicCookieStore();
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setDefaultRequestConfig(this.globalConfig).setDefaultCookieStore(this.cookieStore);
            httpClientBuilder.setMaxConnPerRoute(1000);
            httpClientBuilder.setMaxConnTotal(1000);
            if (fusionUser != null && fusionRealm == null) {
                httpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)new PreEmptiveBasicAuthenticator(fusionUser, fusionPass));
            }
            this.httpClient = httpClientBuilder.build();
        }
        this.originalHostAndPortList = Arrays.asList(fusionHostAndPortList.split(","));
        try {
            this.sessions = this.establishSessions(this.originalHostAndPortList, fusionUser, fusionPass, fusionRealm);
        }
        catch (Exception exc) {
            if (exc instanceof RuntimeException) {
                throw (RuntimeException)exc;
            }
            throw new RuntimeException(exc);
        }
        this.random = new Random();
        this.jsonObjectMapper = new ObjectMapper();
        this.jsonObjectMapper.registerModule((Module)new DefaultScalaModule());
        this.requestCounter = new AtomicInteger(0);
    }

    public String getFusionUser() {
        return this.fusionUser;
    }

    public String getFusionRealm() {
        return this.fusionRealm;
    }

    public void setMetricsRegistry(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    protected Meter getMeterByHost(String meterName, String host) {
        if (this.metrics == null) {
            return null;
        }
        String key = meterName + " (" + host + ")";
        Meter meter = this.metersByHost.get(key);
        if (meter == null) {
            meter = this.metrics.meter(meterName + "-" + host);
            this.metersByHost.put(key, meter);
        }
        return meter;
    }

    protected Map<String, FusionSession> establishSessions(List<String> hostAndPortList, String user, String password, String realm) throws Exception {
        Exception lastError = null;
        HashMap<String, FusionSession> map = new HashMap<String, FusionSession>();
        for (String url : hostAndPortList) {
            String sessionKey = this.getSessionKey(url);
            if (map.containsKey(sessionKey)) continue;
            try {
                FusionSession session = this.establishSession(sessionKey, user, password, realm);
                map.put(session.id, session);
            }
            catch (Exception exc) {
                lastError = exc;
                log.warn((Object)("Failed to establish session with Fusion at " + sessionKey + " due to: " + exc));
            }
        }
        if (map.isEmpty()) {
            if (lastError != null) {
                throw lastError;
            }
            throw new Exception("Failed to establish session with Fusion host(s): " + hostAndPortList);
        }
        log.info((Object)("Established sessions with " + map.size() + " of " + hostAndPortList.size() + " Fusion hosts for user " + user + " in realm " + realm));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FusionSession establishSession(String sessionKey, String user, String password, String realm) throws Exception {
        if (!sessionKey.startsWith("https://") && !sessionKey.startsWith("http://")) {
            sessionKey = "http://" + sessionKey;
        }
        FusionSession fusionSession = new FusionSession();
        if (!this.isKerberos && realm != null) {
            block12: {
                String sessionApi = sessionKey + "/api/session?realmName=" + realm;
                String jsonString = "{\"username\":\"" + user + "\", \"password\":\"" + password + "\"}";
                URL sessionApiUrl = new URL(sessionApi);
                String sessionHost = sessionApiUrl.getHost();
                try {
                    this.clearCookieForHost(sessionHost);
                }
                catch (Exception exc) {
                    log.warn((Object)("Failed to clear session cookie for " + sessionHost + " due to: " + exc));
                }
                HttpPost postRequest = new HttpPost(sessionApiUrl.toURI());
                postRequest.setEntity((HttpEntity)new StringEntity(jsonString, ContentType.create((String)"application/json", (Charset)StandardCharsets.UTF_8)));
                HttpClientContext context = HttpClientContext.create();
                context.setCookieStore(this.cookieStore);
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)postRequest, (HttpContext)context);
                HttpEntity entity = response.getEntity();
                try {
                    String body;
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200 && statusCode != 201 && statusCode != 204) {
                        String body2 = FusionPipelineClient.extractResponseBodyText(entity);
                        throw new SolrException(SolrException.ErrorCode.getErrorCode((int)statusCode), "POST credentials to Fusion Session API [" + sessionApi + "] failed due to: " + response.getStatusLine() + ": " + body2);
                    }
                    if (statusCode != 401 || (body = FusionPipelineClient.extractResponseBodyText(entity)) == null || body.indexOf("session-idle-timeout") == -1) break block12;
                    EntityUtils.consume((HttpEntity)entity);
                    log.warn((Object)("Received session-idle-timeout error from Fusion Session API, re-trying to establish a new session to " + sessionKey));
                    try {
                        this.clearCookieForHost(sessionHost);
                    }
                    catch (Exception exc) {
                        log.warn((Object)("Failed to clear session cookie for " + sessionHost + " due to: " + exc));
                    }
                    response = this.httpClient.execute((HttpUriRequest)postRequest, (HttpContext)context);
                    entity = response.getEntity();
                    statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200 && statusCode != 201 && statusCode != 204) {
                        body = FusionPipelineClient.extractResponseBodyText(entity);
                        throw new SolrException(SolrException.ErrorCode.getErrorCode((int)statusCode), "POST credentials to Fusion Session API [" + sessionApi + "] failed due to: " + response.getStatusLine() + ": " + body);
                    }
                }
                finally {
                    if (entity != null) {
                        EntityUtils.consume((HttpEntity)entity);
                    }
                }
            }
            log.info((Object)("Established secure session with Fusion Session API on " + sessionKey + " for user " + user + " in realm " + realm));
        }
        fusionSession.sessionEstablishedAt = System.nanoTime();
        fusionSession.docsSentMeter = this.getMeterByHost("Docs Sent to Fusion", sessionKey);
        fusionSession.id = sessionKey;
        return fusionSession;
    }

    protected synchronized void clearCookieForHost(String sessionHost) throws Exception {
        Cookie sessionCookie = null;
        for (Cookie cookie : this.cookieStore.getCookies()) {
            String cookieDomain = cookie.getDomain();
            if (cookieDomain == null || !sessionHost.equals(cookieDomain) && sessionHost.indexOf(cookieDomain) == -1 && cookieDomain.indexOf(sessionHost) == -1) continue;
            sessionCookie = cookie;
            break;
        }
        if (sessionCookie != null) {
            BasicClientCookie httpCookie = new BasicClientCookie(sessionCookie.getName(), sessionCookie.getValue());
            httpCookie.setExpiryDate(new Date(0L));
            httpCookie.setVersion(1);
            httpCookie.setPath(sessionCookie.getPath());
            httpCookie.setDomain(sessionCookie.getDomain());
            this.cookieStore.addCookie((Cookie)httpCookie);
        }
        this.cookieStore.clearExpired(new Date());
    }

    protected String getSessionKey(String url) throws Exception {
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            url = "http://" + url;
        }
        URL javaUrl = new URL(url);
        return javaUrl.getProtocol() + "://" + javaUrl.getHost() + ":" + javaUrl.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FusionSession getSession(String url, int requestId) throws Exception {
        FusionSession fusionSession;
        String sessionKey = this.getSessionKey(url);
        FusionPipelineClient fusionPipelineClient = this;
        synchronized (fusionPipelineClient) {
            fusionSession = this.sessions.get(sessionKey);
            long currTime = System.nanoTime();
            if (fusionSession == null || currTime - fusionSession.sessionEstablishedAt > maxNanosOfInactivity) {
                log.info((Object)("Fusion session is likely expired (or soon will be) for " + url + ", " + "pre-emptively re-setting this session before processing request " + requestId));
                fusionSession = this.resetSession(sessionKey);
                if (fusionSession == null) {
                    throw new IllegalStateException("Failed to re-connect to " + url + " after session loss when processing request " + requestId);
                }
            }
        }
        return fusionSession;
    }

    protected synchronized FusionSession resetSession(String sessionKey) throws Exception {
        FusionSession fusionSession;
        try {
            fusionSession = this.establishSession(sessionKey, this.fusionUser, this.fusionPass, this.fusionRealm);
            this.sessions.put(fusionSession.id, fusionSession);
        }
        catch (Exception exc) {
            log.error((Object)("Failed to re-establish session with Fusion at " + sessionKey + " due to: " + exc));
            this.sessions.remove(sessionKey);
            fusionSession = null;
        }
        return fusionSession;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getAvailableServer() {
        try {
            return this.getLbServer(this.getAvailableServers());
        }
        catch (Exception exc) {
            if (exc instanceof RuntimeException) {
                throw (RuntimeException)exc;
            }
            throw new RuntimeException(exc);
        }
    }

    protected String getLbServer(List<String> list) {
        int num = list.size();
        if (num == 0) {
            return null;
        }
        return list.get(num > 1 ? this.random.nextInt(num) : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getAvailableServers() throws Exception {
        ArrayList<String> mutable;
        FusionPipelineClient fusionPipelineClient = this;
        synchronized (fusionPipelineClient) {
            mutable = new ArrayList<String>(this.sessions.keySet());
        }
        if (mutable.isEmpty()) {
            fusionPipelineClient = this;
            synchronized (fusionPipelineClient) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                }
                this.sessions = this.establishSessions(this.originalHostAndPortList, this.fusionUser, this.fusionPass, this.fusionRealm);
                mutable = new ArrayList<String>(this.sessions.keySet());
            }
            if (mutable.isEmpty()) {
                throw new IllegalStateException("No available endpoints! Check log for previous errors as to why there are no more endpoints available. This is a fatal error.");
            }
        }
        return mutable;
    }

    public void postBatchToPipeline(String pipelinePath, List docs) throws Exception {
        int numDocs = docs.size();
        if (!pipelinePath.startsWith("/")) {
            pipelinePath = "/" + pipelinePath;
        }
        int requestId = this.requestCounter.incrementAndGet();
        ArrayList<String> mutable = this.getAvailableServers();
        if (mutable.size() > 1) {
            Exception lastExc = null;
            while (!mutable.isEmpty()) {
                Exception retryAfterException;
                String hostAndPort = this.getLbServer(mutable);
                if (hostAndPort == null) {
                    if (lastExc != null) {
                        log.error((Object)("No more hosts available to retry failed request (" + requestId + ")! raising last seen error: " + lastExc));
                        throw lastExc;
                    }
                    throw new RuntimeException("No Fusion hosts available to process request " + requestId + "! Check logs for previous errors.");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("POSTing batch of " + numDocs + " input docs to " + hostAndPort + pipelinePath + " as request " + requestId));
                }
                if ((retryAfterException = this.postJsonToPipelineWithRetry(hostAndPort, pipelinePath, docs, mutable, lastExc, requestId)) == null) {
                    lastExc = null;
                    break;
                }
                lastExc = retryAfterException;
            }
            if (lastExc != null) {
                log.error((Object)("Failing request " + requestId + " due to: " + lastExc));
                throw lastExc;
            }
        } else {
            Exception exc;
            String hostAndPort = this.getLbServer(mutable);
            if (log.isDebugEnabled()) {
                log.debug((Object)("POSTing batch of " + numDocs + " input docs to " + hostAndPort + pipelinePath + " as request " + requestId));
            }
            if ((exc = this.postJsonToPipelineWithRetry(hostAndPort, pipelinePath, docs, mutable, null, requestId)) != null) {
                throw exc;
            }
        }
    }

    protected Exception postJsonToPipelineWithRetry(String hostAndPort, String pipelinePath, List docs, ArrayList<String> mutable, Exception lastExc, int requestId) throws Exception {
        String url = hostAndPort + pipelinePath;
        Exception retryAfterException = null;
        try {
            this.postJsonToPipeline(hostAndPort, pipelinePath, docs, requestId);
            if (lastExc != null) {
                log.info((Object)("Re-try request " + requestId + " to " + url + " succeeded after seeing a " + lastExc.getMessage()));
            }
        }
        catch (Exception exc) {
            log.warn((Object)("Failed to send request " + requestId + " to '" + url + "' due to: " + exc));
            if (mutable.size() > 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will re-try failed request " + requestId + " on next host in the list"));
                }
                mutable.remove(hostAndPort);
                retryAfterException = exc;
            }
            log.warn((Object)("No more Fusion servers available to try ... will retry to send request " + requestId + " to " + url + " after waiting 1 sec"));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                Thread.interrupted();
            }
            this.postJsonToPipeline(hostAndPort, pipelinePath, docs, requestId);
            log.info((Object)("Re-try request " + requestId + " to " + url + " succeeded"));
            retryAfterException = null;
        }
        return retryAfterException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void postJsonToPipeline(String hostAndPort, String pipelinePath, List docs, int requestId) throws Exception {
        FusionSession fusionSession = this.getSession(hostAndPort, requestId);
        String postUrl = hostAndPort + pipelinePath;
        postUrl = postUrl.indexOf("?") != -1 ? postUrl + "&echo=false" : postUrl + "?echo=false";
        HttpPost postRequest = new HttpPost(postUrl);
        EntityTemplate et = new EntityTemplate((ContentProducer)new JacksonContentProducer(this.jsonObjectMapper, docs));
        et.setContentType(PIPELINE_DOC_CONTENT_TYPE);
        et.setContentEncoding(StandardCharsets.UTF_8.name());
        postRequest.setEntity((HttpEntity)et);
        HttpEntity entity = null;
        try {
            CloseableHttpResponse response;
            HttpClientContext context = null;
            if (this.isKerberos) {
                response = this.httpClient.execute((HttpUriRequest)postRequest);
            } else {
                context = HttpClientContext.create();
                if (this.cookieStore != null) {
                    context.setCookieStore(this.cookieStore);
                }
                response = this.httpClient.execute((HttpUriRequest)postRequest, (HttpContext)context);
            }
            entity = response.getEntity();
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                log.warn((Object)("Unauthorized error (401) when trying to send request " + requestId + " to Fusion at " + hostAndPort + ", will re-try to establish session"));
                try {
                    EntityUtils.consume((HttpEntity)entity);
                }
                catch (Exception ignore) {
                    log.warn((Object)("Failed to consume entity due to: " + ignore));
                }
                finally {
                    entity = null;
                }
                FusionPipelineClient fusionPipelineClient = this;
                synchronized (fusionPipelineClient) {
                    fusionSession = this.resetSession(hostAndPort);
                    if (fusionSession == null) {
                        throw new IllegalStateException("After re-establishing session when processing request " + requestId + ", hostAndPort " + hostAndPort + " is no longer active! Try another hostAndPort.");
                    }
                }
                log.info((Object)("Going to re-try request " + requestId + " after session re-established with " + hostAndPort));
                response = this.isKerberos ? this.httpClient.execute((HttpUriRequest)postRequest) : this.httpClient.execute((HttpUriRequest)postRequest, (HttpContext)context);
                entity = response.getEntity();
                statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200 || statusCode == 204) {
                    log.info((Object)("Re-try request " + requestId + " after session timeout succeeded for: " + hostAndPort));
                } else {
                    this.raiseFusionServerException(hostAndPort, entity, statusCode, (HttpResponse)response, requestId);
                }
            } else if (statusCode != 200 && statusCode != 204) {
                this.raiseFusionServerException(hostAndPort, entity, statusCode, (HttpResponse)response, requestId);
            } else if (fusionSession != null && fusionSession.docsSentMeter != null) {
                fusionSession.docsSentMeter.mark((long)docs.size());
            }
            if (entity == null) return;
        }
        catch (Throwable throwable) {
            if (entity == null) throw throwable;
            try {
                EntityUtils.consume(entity);
                throw throwable;
            }
            catch (Exception ignore) {
                log.warn((Object)("Failed to consume entity due to: " + ignore));
            }
            throw throwable;
        }
        try {
            EntityUtils.consume((HttpEntity)entity);
            return;
        }
        catch (Exception ignore) {
            log.warn((Object)("Failed to consume entity due to: " + ignore));
        }
    }

    public HttpEntity sendRequestToFusion(HttpUriRequest httpRequest) throws Exception {
        return this.sendRequestToFusion(httpRequest, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpEntity sendRequestToFusion(HttpUriRequest httpRequest, boolean retry) throws Exception {
        CloseableHttpResponse response;
        String endpoint = httpRequest.getRequestLine().getUri();
        int requestId = this.requestCounter.incrementAndGet();
        FusionSession fusionSession = this.getSession(endpoint, requestId);
        HttpClientContext context = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending " + httpRequest.getMethod() + " request to: " + endpoint));
        }
        if (this.isKerberos) {
            response = this.httpClient.execute(httpRequest);
        } else {
            context = HttpClientContext.create();
            if (this.cookieStore != null) {
                context.setCookieStore(this.cookieStore);
            }
            response = this.httpClient.execute(httpRequest, (HttpContext)context);
        }
        HttpEntity entity = response.getEntity();
        int statusCode = response.getStatusLine().getStatusCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)(httpRequest.getMethod() + " request to " + endpoint + " returned: " + statusCode));
        }
        if (!retry) {
            if (statusCode == 200 || statusCode == 204) {
                return entity;
            }
            this.raiseFusionServerException(endpoint, entity, statusCode, (HttpResponse)response, requestId);
        }
        if (statusCode == 401) {
            log.warn((Object)("Unauthorized error (401) when trying to send request " + requestId + " to Fusion at " + endpoint + ", will re-try to establish session"));
            try {
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (Exception ignore) {
                log.warn((Object)("Failed to consume entity due to: " + ignore));
            }
            finally {
                entity = null;
            }
            String sessionKey = fusionSession.id;
            FusionPipelineClient fusionPipelineClient = this;
            synchronized (fusionPipelineClient) {
                fusionSession = this.resetSession(sessionKey);
                if (fusionSession == null) {
                    throw new IllegalStateException("After re-establishing session when processing request " + requestId + ", Fusion host " + sessionKey + " is no longer active! Try another server.");
                }
            }
            log.info((Object)("Going to re-try request " + requestId + " after session re-established with " + sessionKey));
            response = this.isKerberos ? this.httpClient.execute(httpRequest) : this.httpClient.execute(httpRequest, (HttpContext)context);
            entity = response.getEntity();
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200 || statusCode == 204) {
                log.info((Object)("Re-try request " + requestId + " after session timeout succeeded for: " + endpoint));
            } else {
                this.raiseFusionServerException(endpoint, entity, statusCode, (HttpResponse)response, requestId);
            }
        } else if (statusCode != 200 && statusCode != 204) {
            this.raiseFusionServerException(endpoint, entity, statusCode, (HttpResponse)response, requestId);
        }
        return entity;
    }

    protected void raiseFusionServerException(String endpoint, HttpEntity entity, int statusCode, HttpResponse response, int requestId) {
        String body = FusionPipelineClient.extractResponseBodyText(entity);
        throw new SolrException(SolrException.ErrorCode.getErrorCode((int)statusCode), "Request " + requestId + " to [" + endpoint + "] failed due to: (" + statusCode + ")" + response.getStatusLine() + ": " + body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractResponseBodyText(HttpEntity entity) {
        StringBuilder body = new StringBuilder();
        if (entity != null) {
            BufferedReader reader = null;
            String line = null;
            try {
                reader = new BufferedReader(new InputStreamReader(entity.getContent()));
                while ((line = reader.readLine()) != null) {
                    body.append(line);
                }
            }
            catch (Exception ignore) {
                log.warn((Object)("Failed to read response body due to: " + ignore));
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return body.toString();
    }

    public synchronized void shutdown() {
        if (this.sessions != null) {
            this.sessions.clear();
            this.sessions = null;
        }
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                log.warn((Object)("Failed to close httpClient object due to: " + e));
            }
            finally {
                this.httpClient = null;
            }
        } else {
            log.error((Object)"Already shutdown.");
        }
    }

    private class JacksonContentProducer
    implements ContentProducer {
        ObjectMapper mapper;
        Object jsonObj;

        JacksonContentProducer(ObjectMapper mapper, Object jsonObj) {
            this.mapper = mapper;
            this.jsonObj = jsonObj;
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            this.mapper.writeValue(outputStream, this.jsonObj);
        }
    }

    static class FusionSession {
        String id;
        long sessionEstablishedAt = -1L;
        Meter docsSentMeter = null;

        FusionSession() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.id);
            if (this.sessionEstablishedAt > 0L) {
                sb.append(": ").append(TimeUnit.SECONDS.convert(this.sessionEstablishedAt, TimeUnit.NANOSECONDS));
            }
            if (this.docsSentMeter != null) {
                sb.append(", docsSent: ").append(this.docsSentMeter.getCount());
            }
            return sb.toString();
        }
    }

    private static final class PreEmptiveBasicAuthenticator
    implements HttpRequestInterceptor {
        private final UsernamePasswordCredentials credentials;

        public PreEmptiveBasicAuthenticator(String user, String pass) {
            this.credentials = new UsernamePasswordCredentials(user, pass);
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.addHeader(BasicScheme.authenticate((Credentials)this.credentials, (String)"US-ASCII", (boolean)false));
        }
    }
}

