/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.query;

import com.lucidworks.spark.query.AbstractShardSplit;
import com.lucidworks.spark.query.ShardSplit;
import com.lucidworks.spark.query.ShardSplitStrategy;
import com.lucidworks.spark.util.SolrSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;

public abstract class AbstractFieldShardSplitStrategy<T>
implements ShardSplitStrategy,
Serializable {
    public static Logger log = Logger.getLogger(AbstractFieldShardSplitStrategy.class);
    protected static final double thresholdFactor = 1.18;
    protected static final double splitSizeWarnThreshold = 1.4;
    protected static final double resplitThreshold = 1.5;
    protected static final double smallDocsFactor = 1.8;

    @Override
    public List<ShardSplit> getSplits(String shardUrl, SolrQuery query, String splitFieldName, int splitsPerShard) throws IOException, SolrServerException {
        long _startMs = System.currentTimeMillis();
        List<ShardSplit> splits = new ArrayList<ShardSplit>(splitsPerShard);
        try (HttpSolrClient solrClient = SolrSupport.getHttpSolrClient(shardUrl);){
            FieldStatsInfo fsi = this.appendSplits((SolrClient)solrClient, splits, query, shardUrl, splitFieldName, splitsPerShard);
            long docsPerSplit = Math.round(fsi.getCount() / (long)splitsPerShard);
            long threshold = Math.round(1.18 * (double)docsPerSplit);
            for (int b = 0; b < 3; ++b) {
                splits = this.balanceSplits(splits, threshold, docsPerSplit, (SolrClient)solrClient, fsi, splitsPerShard, 0);
            }
            this.joinNonAdjacentSmallSplits(fsi, splits, threshold);
            Long missingCount = fsi.getMissing();
            if (missingCount == null) {
                SolrQuery missingQuery = query.getCopy();
                missingQuery.addFilterQuery(new String[]{"-" + splitFieldName + ":[* TO *]"});
                missingQuery.setRows(Integer.valueOf(0));
                QueryResponse qr = solrClient.query((SolrParams)missingQuery);
                missingCount = qr.getResults().getNumFound();
            }
            if (missingCount > 0L) {
                FqSplit missingValuesSplit = new FqSplit(query, shardUrl, splitFieldName, "-" + splitFieldName + ":[* TO *]");
                missingValuesSplit.setNumHits(missingCount);
                splits.add(missingValuesSplit);
                if (missingCount > docsPerSplit * 2L) {
                    log.warn((Object)("Found " + missingCount + " missing values for field " + splitFieldName + " in shard " + shardUrl + ". This can lead to poor performance when processing this shard."));
                }
            }
        }
        long _diffMs = System.currentTimeMillis() - _startMs;
        long total = 0L;
        for (ShardSplit ss : splits) {
            total += ss.getNumHits().longValue();
        }
        long avg = Math.round((double)total / (double)splits.size());
        log.info((Object)("Took " + _diffMs + " ms to find " + splits.size() + " splits for " + splitFieldName + " with avg size: " + avg + ", total: " + total));
        long high = Math.round((double)avg * 1.4);
        for (int s = 0; s < splits.size(); ++s) {
            ShardSplit ss = splits.get(s);
            long numHits = ss.getNumHits();
            if (numHits <= high) continue;
            double p = (double)numHits / (double)avg - 1.0;
            long pct = Math.round(p * 100.0);
            log.warn((Object)("Size of split " + s + " " + ss + " is " + pct + "% larger than the avg split size " + avg + "; this could lead to sub-optimal job execution times."));
        }
        return splits;
    }

    protected FieldStatsInfo getFieldStatsInfo(SolrClient solrClient, String shardUrl, SolrQuery solrQuery, String splitFieldName) throws IOException, SolrServerException {
        SolrQuery statsQuery = solrQuery.getCopy();
        statsQuery.setRows(Integer.valueOf(0));
        statsQuery.setStart(Integer.valueOf(0));
        statsQuery.set("distrib", false);
        statsQuery.setFields(new String[]{splitFieldName});
        statsQuery.remove("cursorMark");
        statsQuery.setGetFieldStatistics(splitFieldName);
        QueryResponse qr = solrClient.query((SolrParams)statsQuery);
        return (FieldStatsInfo)qr.getFieldStatsInfo().get(splitFieldName);
    }

    public Long fetchNumHits(SolrClient solrClient, ShardSplit split) throws IOException, SolrServerException {
        SolrQuery splitQuery = split.getQuery().getCopy();
        splitQuery.addFilterQuery(new String[]{split.getSplitFilterQuery()});
        splitQuery.setRows(Integer.valueOf(0));
        splitQuery.setStart(Integer.valueOf(0));
        splitQuery.setFields(new String[]{split.getSplitFieldName()});
        QueryResponse qr = solrClient.query((SolrParams)splitQuery);
        split.setNumHits(qr.getResults().getNumFound());
        return split.getNumHits();
    }

    protected FieldStatsInfo appendSplits(SolrClient solrClient, List<ShardSplit> splits, SolrQuery query, String shardUrl, String splitFieldName, int splitsPerShard) throws IOException, SolrServerException {
        FieldStatsInfo fsi = this.getFieldStatsInfo(solrClient, shardUrl, query, splitFieldName);
        if (fsi.getCount() > 0L) {
            if (fsi.getMin() == null || fsi.getMax() == null) {
                throw new IllegalStateException("No min/max for " + splitFieldName + "! Check your Solr index to verify if " + splitFieldName + " has values.");
            }
            log.info((Object)("Using stats: " + fsi));
            ShardSplit<Object> firstSplit = this.createShardSplit(query, shardUrl, splitFieldName, fsi, null, null);
            long numHits = fsi.getCount();
            firstSplit.setNumHits(numHits);
            long docsPerSplit = Math.round(numHits / (long)splitsPerShard);
            splits.addAll(this.reSplit(solrClient, firstSplit, docsPerSplit, fsi));
        }
        return fsi;
    }

    protected List<ShardSplit> balanceSplits(List<ShardSplit> splits, long threshold, long docsPerSplit, SolrClient solrClient, FieldStatsInfo fsi, int splitsPerShard, int depth) throws IOException, SolrServerException {
        ArrayList<ShardSplit> finalSplits = new ArrayList<ShardSplit>(splits.size());
        for (int s = 0; s < splits.size(); ++s) {
            ShardSplit split = splits.get(s);
            long hits = split.getNumHits();
            if (hits < threshold && s < splits.size() - 1) {
                long nextJoinSize;
                int j = s;
                while ((nextJoinSize = split.getNumHits() + splits.get(j + 1).getNumHits()) <= threshold) {
                    split = this.join(fsi, split, splits.get(++j));
                    if (j + 1 != splits.size() && split.getNumHits() < threshold) continue;
                }
                finalSplits.add(split);
                s = j;
                continue;
            }
            if (depth <= 20 && (double)hits > (double)docsPerSplit * 1.5) {
                long resplitDocsPerSplit = splitsPerShard <= 4 ? Math.round((double)docsPerSplit * 0.6) : docsPerSplit;
                List<ShardSplit> reSplitList = this.reSplit(solrClient, split, resplitDocsPerSplit, fsi);
                if (reSplitList.size() > 1) {
                    reSplitList = this.balanceSplits(reSplitList, threshold, docsPerSplit, solrClient, fsi, splitsPerShard, ++depth);
                }
                finalSplits.addAll(reSplitList);
                continue;
            }
            finalSplits.add(split);
        }
        return finalSplits;
    }

    public List<ShardSplit> reSplit(SolrClient solrClient, ShardSplit<T> toBeSplit, long docsPerSplit, FieldStatsInfo fsi) throws IOException, SolrServerException {
        long bucketSize;
        int numSplits;
        ArrayList<ShardSplit> list = new ArrayList<ShardSplit>();
        long range = toBeSplit.getRange();
        if (range <= 0L) {
            list.add(toBeSplit);
            return list;
        }
        long _startMs = System.currentTimeMillis();
        int n = numSplits = docsPerSplit > 0L ? Math.round(toBeSplit.getNumHits() / docsPerSplit) : 1;
        if (numSplits == 1 && toBeSplit.getNumHits() > docsPerSplit) {
            numSplits = 2;
        }
        if ((bucketSize = Math.round((double)range / (double)numSplits)) < 1L) {
            list.add(toBeSplit);
            return list;
        }
        T lowerBound = toBeSplit.getLowerInc();
        for (int b = 0; b < numSplits; ++b) {
            T upperBound = b < numSplits - 1 ? toBeSplit.nextUpper(lowerBound, bucketSize) : toBeSplit.getUpper();
            ShardSplit<T> sub = this.createShardSplit(toBeSplit.getQuery(), toBeSplit.getShardUrl(), toBeSplit.getSplitFieldName(), fsi, lowerBound, upperBound);
            this.fetchNumHits(solrClient, sub);
            list.add(sub);
            if (b < numSplits - 1 && upperBound.equals(toBeSplit.getUpper())) break;
            lowerBound = upperBound;
        }
        long _diffMs = System.currentTimeMillis() - _startMs;
        log.info((Object)("Took " + _diffMs + " ms to re-split " + toBeSplit.toString() + " into " + list.size() + " sub-splits to achieve " + docsPerSplit + " docs per split"));
        return list;
    }

    protected void joinNonAdjacentSmallSplits(FieldStatsInfo stats, List<ShardSplit> splits, long threshold) {
        long halfDocsPerSplit = Math.round((double)threshold / 1.8);
        block0: for (int b = 0; b < splits.size(); ++b) {
            ShardSplit ss = splits.get(b);
            if (ss.getNumHits() >= halfDocsPerSplit) continue;
            for (int j = b + 1; j < splits.size(); ++j) {
                ShardSplit tmp = splits.get(j);
                if (tmp.getNumHits() >= halfDocsPerSplit) continue;
                splits.set(b, this.join(stats, ss, tmp));
                splits.remove(j);
                continue block0;
            }
        }
    }

    public ShardSplit join(FieldStatsInfo stats, ShardSplit lhs, ShardSplit rhs) {
        ShardSplit joined = null;
        if (lhs.getLowerInc() != null && rhs.getLowerInc() != null) {
            ShardSplit big;
            String lhsLowerInc = String.valueOf(lhs.getLowerInc());
            String rhsLowerInc = String.valueOf(rhs.getLowerInc());
            ShardSplit small = rhsLowerInc.compareTo(lhsLowerInc) < 0 ? rhs : lhs;
            ShardSplit shardSplit = big = small == rhs ? lhs : rhs;
            if (small.getUpper().equals(big.getLowerInc())) {
                joined = this.createShardSplit(lhs.getQuery(), lhs.getShardUrl(), lhs.getSplitFieldName(), stats, small.getLowerInc(), big.getUpper());
            }
        }
        if (joined == null) {
            String fq2 = lhs.getSplitFilterQuery() + " OR " + rhs.getSplitFilterQuery();
            joined = new FqSplit(lhs.getQuery(), lhs.getShardUrl(), lhs.getSplitFieldName(), fq2);
        }
        joined.setNumHits(lhs.getNumHits() + rhs.getNumHits());
        return joined;
    }

    protected abstract ShardSplit<T> createShardSplit(SolrQuery var1, String var2, String var3, FieldStatsInfo var4, T var5, T var6);

    class FqSplit
    extends AbstractShardSplit<String> {
        FqSplit(SolrQuery query, String shardUrl, String rangeField, String fq2) {
            super(query, shardUrl, rangeField, fq2);
        }

        @Override
        public String nextUpper(String lower, long increment) {
            return null;
        }

        @Override
        public long getRange() {
            return 0L;
        }
    }
}

