/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.query;

import com.lucidworks.spark.query.ShardSplit;
import java.io.Serializable;
import org.apache.solr.client.solrj.SolrQuery;

public abstract class AbstractShardSplit<T>
implements ShardSplit<T>,
Serializable {
    protected SolrQuery query;
    protected String shardUrl;
    protected String rangeField;
    protected T lowerInc;
    protected T upper;
    protected T min;
    protected T max;
    protected Long numHits = null;
    protected String fq;

    protected AbstractShardSplit(SolrQuery query, String shardUrl, String rangeField, T min, T max, T lowerInc, T upper) {
        this.query = query;
        this.shardUrl = shardUrl;
        this.rangeField = rangeField;
        this.min = min;
        this.max = max;
        this.lowerInc = lowerInc;
        this.upper = upper;
        this.fq = this.buildSplitFq();
    }

    protected AbstractShardSplit(SolrQuery query, String shardUrl, String rangeField, String fq2) {
        this.query = query;
        this.shardUrl = shardUrl;
        this.rangeField = rangeField;
        this.fq = fq2;
    }

    protected String buildSplitFq() {
        StringBuilder sb = new StringBuilder();
        if (this.lowerInc != null) {
            if (this.lowerInc.equals(this.upper)) {
                sb.append(this.rangeField).append(":").append(this.lowerInc);
            } else {
                String exc = this.max.equals(this.upper) ? "]" : "}";
                sb.append(this.rangeField).append(":[").append(this.lowerInc).append(" TO ").append(this.upper).append(exc);
            }
        } else {
            sb.append("-").append(this.rangeField).append(":[* TO *]");
        }
        return sb.toString();
    }

    @Override
    public SolrQuery getQuery() {
        return this.query;
    }

    @Override
    public SolrQuery getSplitQuery() {
        SolrQuery splitQuery = this.query.getCopy();
        splitQuery.addFilterQuery(new String[]{this.getSplitFilterQuery()});
        return splitQuery;
    }

    @Override
    public String getSplitFieldName() {
        return this.rangeField;
    }

    @Override
    public String getSplitFilterQuery() {
        return this.fq;
    }

    @Override
    public String getShardUrl() {
        return this.shardUrl;
    }

    @Override
    public T getUpper() {
        return this.upper;
    }

    @Override
    public T getLowerInc() {
        return this.lowerInc;
    }

    @Override
    public Long getNumHits() {
        return this.numHits;
    }

    @Override
    public void setNumHits(Long numHits) {
        this.numHits = numHits;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fq).append(" (").append(this.numHits != null ? this.numHits.toString() : "?").append(")");
        return sb.toString();
    }
}

