/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.query;

import com.lucidworks.spark.query.AbstractFieldShardSplitStrategy;
import com.lucidworks.spark.query.AbstractShardSplit;
import com.lucidworks.spark.query.ShardSplit;
import java.io.IOException;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

public class NumberFieldShardSplitStrategy
extends AbstractFieldShardSplitStrategy<Long>
implements Serializable {
    public static Logger log = Logger.getLogger(NumberFieldShardSplitStrategy.class);

    @Override
    protected ShardSplit<Long> createShardSplit(SolrQuery query, String shardUrl, String rangeField, FieldStatsInfo stats, Long lowerInc, Long upper) {
        Long min = (Long)stats.getMin();
        Long max = (Long)stats.getMax();
        if (lowerInc == null) {
            lowerInc = min;
        }
        if (upper == null) {
            upper = max;
        }
        return new NumericShardSplit(query, shardUrl, rangeField, min, max, lowerInc, upper);
    }

    @Override
    protected FieldStatsInfo getFieldStatsInfo(SolrClient solrClient, String shardUrl, SolrQuery solrQuery, String splitFieldName) throws IOException, SolrServerException {
        long _startMs = System.currentTimeMillis();
        SolrQuery statsQuery = solrQuery.getCopy();
        statsQuery.setRows(Integer.valueOf(1));
        statsQuery.setStart(Integer.valueOf(0));
        statsQuery.set("distrib", false);
        statsQuery.remove("cursorMark");
        statsQuery.setFields(new String[]{splitFieldName});
        statsQuery.setSort(splitFieldName, SolrQuery.ORDER.asc);
        QueryResponse qr = solrClient.query((SolrParams)statsQuery);
        SolrDocumentList results = qr.getResults();
        NamedList nl = new NamedList();
        long count = qr.getResults().getNumFound();
        if (count != 0L) {
            Object o = ((SolrDocument)results.get(0)).getFirstValue(splitFieldName);
            long min = Long.parseLong(o.toString());
            statsQuery.setSort(splitFieldName, SolrQuery.ORDER.desc);
            qr = solrClient.query((SolrParams)statsQuery);
            long max = Long.parseLong(((SolrDocument)qr.getResults().get(0)).getFirstValue(splitFieldName).toString());
            nl.add("min", (Object)new Long(min));
            nl.add("max", (Object)new Long(max));
            nl.add("count", (Object)new Long(count));
            long _diffMs = System.currentTimeMillis() - _startMs;
            log.info((Object)("Took " + _diffMs + " ms to lookup min/max from index for " + splitFieldName + " in shard " + shardUrl));
        } else {
            nl.add("count", (Object)new Long(count));
            log.info((Object)"Cannot get min/max for because no results were produced by the query ");
        }
        return new FieldStatsInfo(nl, splitFieldName);
    }

    class NumericShardSplit
    extends AbstractShardSplit<Long> {
        NumericShardSplit(SolrQuery query, String shardUrl, String rangeField, Long min, Long max, Long lowerInc, Long upper) {
            super(query, shardUrl, rangeField, min, max, lowerInc, upper);
        }

        @Override
        public Long nextUpper(Long lower, long increment) {
            Long nextUpper = lower + increment;
            return nextUpper < (Long)this.upper ? nextUpper : (Long)this.upper;
        }

        @Override
        public long getRange() {
            return (Long)this.upper - (Long)this.lowerInc;
        }
    }
}

