/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.query;

import com.lucidworks.spark.util.SolrQuerySupport;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import scala.Option;

public abstract class PagedResultsIterator<T>
implements Iterator<T>,
Iterable<T> {
    protected static final int DEFAULT_PAGE_SIZE = 50;
    protected SolrClient solrServer;
    protected SolrQuery solrQuery;
    protected int currentPageSize = 0;
    protected int iterPos = 0;
    protected long totalDocs = 0L;
    protected long numDocs = 0L;
    protected String cursorMark = null;
    protected boolean closeAfterIterating = false;
    protected List<T> currentPage;

    public PagedResultsIterator(SolrClient solrServer, SolrQuery solrQuery) {
        this(solrServer, solrQuery, null);
    }

    public PagedResultsIterator(SolrClient solrServer, SolrQuery solrQuery, String cursorMark) {
        this.solrServer = solrServer;
        this.closeAfterIterating = !(solrServer instanceof CloudSolrClient);
        this.solrQuery = solrQuery;
        this.cursorMark = cursorMark;
        if (solrQuery.getRows() == null) {
            solrQuery.setRows(Integer.valueOf(50));
        }
    }

    @Override
    public boolean hasNext() {
        boolean hasNext;
        if (this.currentPage == null || this.iterPos == this.currentPageSize) {
            try {
                this.currentPage = this.fetchNextPage();
                this.currentPageSize = this.currentPage.size();
                this.iterPos = 0;
            }
            catch (SolrServerException sse) {
                throw new RuntimeException(sse);
            }
        }
        boolean bl = hasNext = this.iterPos < this.currentPageSize;
        if (!hasNext && this.closeAfterIterating) {
            try {
                this.solrServer.close();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return hasNext;
    }

    protected int getStartForNextPage() {
        Integer currentStart = this.solrQuery.getStart();
        return currentStart != null ? currentStart + this.solrQuery.getRows() : 0;
    }

    protected List<T> fetchNextPage() throws SolrServerException {
        int start = this.cursorMark != null ? 0 : this.getStartForNextPage();
        Option<QueryResponse> resp = SolrQuerySupport.querySolr(this.solrServer, this.solrQuery, start, this.cursorMark);
        if (resp.isDefined()) {
            if (this.cursorMark != null) {
                this.cursorMark = ((QueryResponse)resp.get()).getNextCursorMark();
            }
            this.iterPos = 0;
            SolrDocumentList docs = ((QueryResponse)resp.get()).getResults();
            this.totalDocs = docs.getNumFound();
            return this.processQueryResponse((QueryResponse)resp.get());
        }
        throw new SolrServerException("Found None Query response");
    }

    protected abstract List<T> processQueryResponse(QueryResponse var1);

    @Override
    public T next() {
        if (this.currentPage == null || this.iterPos >= this.currentPageSize) {
            throw new NoSuchElementException("No more docs available!");
        }
        ++this.numDocs;
        return this.currentPage.get(this.iterPos++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

